/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.classic.AbstractBackoff;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class LinearBackoffManager
extends AbstractBackoff {
    private static final Logger LOG = LoggerFactory.getLogger(LinearBackoffManager.class);
    private final int increment;
    private final ConcurrentHashMap<HttpRoute, AtomicInteger> routeAttempts;

    public LinearBackoffManager(ConnPoolControl<HttpRoute> connPoolControl) {
        this(connPoolControl, 1);
    }

    public LinearBackoffManager(ConnPoolControl<HttpRoute> connPoolControl, int n2) {
        super(connPoolControl);
        this.increment = Args.positive(n2, "Increment");
        this.routeAttempts = new ConcurrentHashMap();
    }

    @Override
    public void backOff(HttpRoute httpRoute2) {
        Instant instant = Instant.now();
        if (this.shouldSkip(httpRoute2, instant)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BackOff not applied for route: {}, cool-down period not elapsed", (Object)httpRoute2);
            }
            return;
        }
        AtomicInteger atomicInteger2 = this.routeAttempts.compute(httpRoute2, (httpRoute, atomicInteger) -> {
            if (atomicInteger == null) {
                return new AtomicInteger(1);
            }
            atomicInteger.incrementAndGet();
            return atomicInteger;
        });
        this.getLastRouteBackoffs().put(httpRoute2, instant);
        int n2 = this.getConnPerRoute().getMaxPerRoute(httpRoute2);
        this.getConnPerRoute().setMaxPerRoute(httpRoute2, this.getBackedOffPoolSize(n2));
        atomicInteger2.incrementAndGet();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Backoff applied for route: {}, new max connections: {}", (Object)httpRoute2, (Object)this.getConnPerRoute().getMaxPerRoute(httpRoute2));
        }
    }

    @Override
    public void probe(HttpRoute httpRoute2) {
        Instant instant = Instant.now();
        if (this.shouldSkip(httpRoute2, instant)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probe not applied for route: {}, cool-down period not elapsed", (Object)httpRoute2);
            }
            return;
        }
        this.routeAttempts.compute(httpRoute2, (httpRoute, atomicInteger) -> {
            if (atomicInteger == null || atomicInteger.get() <= 1) {
                return null;
            }
            atomicInteger.decrementAndGet();
            return atomicInteger;
        });
        this.getLastRouteProbes().put(httpRoute2, instant);
        int n2 = this.getConnPerRoute().getMaxPerRoute(httpRoute2);
        n2 = Math.max(n2 - this.increment, this.getCap().get());
        this.getConnPerRoute().setMaxPerRoute(httpRoute2, n2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Probe applied for route: {}, new max connections: {}", (Object)httpRoute2, (Object)this.getConnPerRoute().getMaxPerRoute(httpRoute2));
        }
    }

    private boolean shouldSkip(HttpRoute object, Instant instant) {
        Instant instant2 = this.getLastRouteProbes().getOrDefault(object, Instant.EPOCH);
        object = this.getLastRouteBackoffs().getOrDefault(object, Instant.EPOCH);
        return Duration.between(instant2, instant).compareTo(this.getCoolDown().get().toDuration()) < 0 || Duration.between((Temporal)object, instant).compareTo(this.getCoolDown().get().toDuration()) < 0;
    }

    @Override
    protected int getBackedOffPoolSize(int n2) {
        return n2 + this.increment;
    }

    @Override
    public void setBackoffFactor(double d2) {
    }
}

