/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.DefaultClientConnectionReuseStrategy;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.InternalExecRuntime;
import org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestClientConnControl;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.DefaultHttpProcessor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class MinimalHttpClient
extends CloseableHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MinimalHttpClient.class);
    private final HttpClientConnectionManager connManager;
    private final ConnectionReuseStrategy reuseStrategy;
    private final SchemePortResolver schemePortResolver;
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;

    MinimalHttpClient(HttpClientConnectionManager httpClientConnectionManager) {
        this.connManager = Args.notNull(httpClientConnectionManager, "HTTP connection manager");
        this.reuseStrategy = DefaultClientConnectionReuseStrategy.INSTANCE;
        this.schemePortResolver = DefaultSchemePortResolver.INSTANCE;
        this.requestExecutor = new HttpRequestExecutor(this.reuseStrategy);
        this.httpProcessor = new DefaultHttpProcessor(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(VersionInfo.getSoftwareInfo("Apache-HttpClient", "org.apache.hc.client5", this.getClass())));
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost object, ClassicHttpRequest object2, HttpContext httpContext) throws IOException {
        Args.notNull(object, "Target host");
        Args.notNull(object2, "HTTP request");
        if (object2.getScheme() == null) {
            object2.setScheme(((HttpHost)object).getSchemeName());
        }
        if (object2.getAuthority() == null) {
            object2.setAuthority(new URIAuthority((NamedEndpoint)object));
        }
        httpContext = HttpClientContext.castOrCreate(httpContext);
        Object object3 = null;
        if (object2 instanceof Configurable) {
            object3 = ((Configurable)object2).getConfig();
        }
        if (object3 != null) {
            ((HttpClientContext)httpContext).setRequestConfig((RequestConfig)object3);
        }
        object = new HttpRoute(RoutingSupport.normalize((HttpHost)object, this.schemePortResolver));
        object3 = ExecSupport.getNextExchangeId();
        ((HttpClientContext)httpContext).setExchangeId((String)object3);
        InternalExecRuntime internalExecRuntime = new InternalExecRuntime(LOG, this.connManager, this.requestExecutor, object2 instanceof CancellableDependency ? (CancellableDependency)object2 : null);
        try {
            if (!internalExecRuntime.isEndpointAcquired()) {
                internalExecRuntime.acquireEndpoint((String)object3, (HttpRoute)object, null, (HttpClientContext)httpContext);
            }
            if (!internalExecRuntime.isEndpointConnected()) {
                internalExecRuntime.connectEndpoint((HttpClientContext)httpContext);
            }
            ((HttpCoreContext)httpContext).setRequest((HttpRequest)object2);
            ((HttpClientContext)httpContext).setRoute((HttpRoute)object);
            Object object4 = object2;
            this.httpProcessor.process((HttpRequest)object4, (EntityDetails)object4.getEntity(), httpContext);
            Object object5 = object = internalExecRuntime.execute((String)object3, (ClassicHttpRequest)object2, (HttpClientContext)httpContext);
            this.httpProcessor.process((HttpResponse)object5, (EntityDetails)object5.getEntity(), httpContext);
            if (this.reuseStrategy.keepAlive((HttpRequest)object2, (HttpResponse)object, httpContext)) {
                internalExecRuntime.markConnectionReusable(null, TimeValue.NEG_ONE_MILLISECOND);
            } else {
                internalExecRuntime.markConnectionNonReusable();
            }
            object2 = object.getEntity();
            if (object2 == null || !object2.isStreaming()) {
                internalExecRuntime.releaseEndpoint();
                return new CloseableHttpResponse((ClassicHttpResponse)object);
            }
            ResponseEntityProxy.enhance((ClassicHttpResponse)object, internalExecRuntime);
            return new CloseableHttpResponse((ClassicHttpResponse)object, internalExecRuntime);
        }
        catch (ConnectionShutdownException connectionShutdownException) {
            object2 = new InterruptedIOException("Connection has been shut down");
            ((Throwable)object2).initCause(connectionShutdownException);
            internalExecRuntime.discardEndpoint();
            throw object2;
        }
        catch (HttpException httpException) {
            internalExecRuntime.discardEndpoint();
            throw new ClientProtocolException(httpException);
        }
        catch (IOException | RuntimeException exception) {
            internalExecRuntime.discardEndpoint();
            throw exception;
        }
        catch (Error error) {
            this.connManager.close(CloseMode.IMMEDIATE);
            throw error;
        }
    }

    @Override
    public void close() throws IOException {
        this.connManager.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.connManager.close(closeMode);
    }
}

