/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthExchange$State;
import org.apache.hc.client5.http.auth.AuthenticationException;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.MalformedChallengeException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChain$Scope;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.RequestSupport;
import org.apache.hc.client5.http.impl.auth.AuthCacheKeeper;
import org.apache.hc.client5.http.impl.auth.AuthenticationHandler;
import org.apache.hc.client5.http.impl.classic.RequestEntityProxy;
import org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.support.AbstractRequestBuilder;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class ProtocolExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolExec.class);
    private final AuthenticationStrategy targetAuthStrategy;
    private final AuthenticationStrategy proxyAuthStrategy;
    private final AuthenticationHandler authenticator;
    private final SchemePortResolver schemePortResolver;
    private final AuthCacheKeeper authCacheKeeper;

    public ProtocolExec(AuthenticationStrategy authenticationStrategy, AuthenticationStrategy authenticationStrategy2, SchemePortResolver schemePortResolver, boolean bl2) {
        this.targetAuthStrategy = Args.notNull(authenticationStrategy, "Target authentication strategy");
        this.proxyAuthStrategy = Args.notNull(authenticationStrategy2, "Proxy authentication strategy");
        this.authenticator = new AuthenticationHandler();
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.authCacheKeeper = bl2 ? null : new AuthCacheKeeper(this.schemePortResolver);
    }

    @Override
    public final ClassicHttpResponse execute(ClassicHttpRequest classicHttpRequest, ExecChain$Scope execChain$Scope, ExecChain execChain) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(execChain$Scope, "Scope");
        if (Method.CONNECT.isSame(classicHttpRequest.getMethod())) {
            throw new ProtocolException("Direct execution of CONNECT is not allowed");
        }
        String string = execChain$Scope.exchangeId;
        HttpRoute httpRoute = execChain$Scope.route;
        HttpClientContext httpClientContext = execChain$Scope.clientContext;
        ExecRuntime execRuntime = execChain$Scope.execRuntime;
        HttpHost object3 = httpRoute.getTargetHost();
        HttpHost httpHost = httpRoute.getProxyHost();
        try {
            Iterator<Header> iterator;
            AuthExchange authExchange;
            Object object;
            if (httpHost != null && !httpRoute.isTunnelled()) {
                object = ClassicRequestBuilder.copy(classicHttpRequest);
                if (((AbstractRequestBuilder)object).getAuthority() == null) {
                    ((ClassicRequestBuilder)object).setAuthority(new URIAuthority(object3));
                }
                ((ClassicRequestBuilder)object).setAbsoluteRequestUri(true);
                classicHttpRequest = ((ClassicRequestBuilder)object).build();
            }
            if (classicHttpRequest.getScheme() == null) {
                classicHttpRequest.setScheme(object3.getSchemeName());
            }
            if (classicHttpRequest.getAuthority() == null) {
                classicHttpRequest.setAuthority(new URIAuthority(object3));
            }
            if (((URIAuthority)(object = classicHttpRequest.getAuthority())).getUserInfo() != null) {
                throw new ProtocolException("Request URI authority contains deprecated userinfo component");
            }
            HttpHost httpHost2 = new HttpHost(classicHttpRequest.getScheme(), ((URIAuthority)object).getHostName(), this.schemePortResolver.resolve(classicHttpRequest.getScheme(), (NamedEndpoint)object));
            object = RequestSupport.extractPathPrefix(classicHttpRequest);
            AuthExchange authExchange2 = httpClientContext.getAuthExchange(httpHost2);
            AuthExchange authExchange3 = authExchange = httpHost != null ? httpClientContext.getAuthExchange(httpHost) : new AuthExchange();
            if (!authExchange2.isConnectionBased() && authExchange2.getPathPrefix() != null && !((String)object).startsWith(authExchange2.getPathPrefix())) {
                authExchange2.reset();
            }
            if (authExchange2.getPathPrefix() == null) {
                authExchange2.setPathPrefix((String)object);
            }
            if (this.authCacheKeeper != null) {
                this.authCacheKeeper.loadPreemptively(httpHost2, (String)object, authExchange2, httpClientContext);
                if (httpHost != null) {
                    this.authCacheKeeper.loadPreemptively(httpHost, null, authExchange, httpClientContext);
                }
            }
            RequestEntityProxy.enhance(classicHttpRequest);
            block3: while (true) {
                if (!classicHttpRequest.containsHeader("Authorization")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} target auth state: {}", (Object)string, (Object)authExchange2.getState());
                    }
                    this.authenticator.addAuthResponse(httpHost2, ChallengeType.TARGET, classicHttpRequest, authExchange2, httpClientContext);
                }
                if (!classicHttpRequest.containsHeader("Proxy-Authorization") && !httpRoute.isTunnelled()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} proxy auth state: {}", (Object)string, (Object)authExchange.getState());
                    }
                    this.authenticator.addAuthResponse(httpHost, ChallengeType.PROXY, classicHttpRequest, authExchange, httpClientContext);
                }
                iterator = execChain.proceed(classicHttpRequest, execChain$Scope);
                if (Method.TRACE.isSame(classicHttpRequest.getMethod())) {
                    ResponseEntityProxy.enhance((ClassicHttpResponse)((Object)iterator), execRuntime);
                    return iterator;
                }
                HttpEntity httpEntity = classicHttpRequest.getEntity();
                if (httpEntity != null && !httpEntity.isRepeatable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} Cannot retry non-repeatable request", (Object)string);
                    }
                    ResponseEntityProxy.enhance((ClassicHttpResponse)((Object)iterator), execRuntime);
                    return iterator;
                }
                if (!this.needAuthentication(authExchange2, authExchange, httpHost != null ? httpHost : httpHost2, httpHost2, (String)object, (HttpResponse)((Object)iterator), httpClientContext)) break;
                iterator = iterator.getEntity();
                if (execRuntime.isConnectionReusable()) {
                    EntityUtils.consume((HttpEntity)((Object)iterator));
                } else {
                    execRuntime.disconnectEndpoint();
                    if (authExchange.getState() == AuthExchange$State.SUCCESS && authExchange.isConnectionBased()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} resetting proxy auth state", (Object)string);
                        }
                        authExchange.reset();
                    }
                    if (authExchange2.getState() == AuthExchange$State.SUCCESS && authExchange2.isConnectionBased()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} resetting target auth state", (Object)string);
                        }
                        authExchange2.reset();
                    }
                }
                iterator = execChain$Scope.originalRequest;
                classicHttpRequest.setHeaders(new Header[0]);
                iterator = iterator.headerIterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    classicHttpRequest.addHeader(iterator.next());
                }
                break;
            }
            ResponseEntityProxy.enhance((ClassicHttpResponse)((Object)iterator), execRuntime);
            return iterator;
        }
        catch (HttpException httpException) {
            execRuntime.discardEndpoint();
            throw httpException;
        }
        catch (IOException | RuntimeException exception) {
            execRuntime.discardEndpoint();
            for (AuthExchange authExchange : httpClientContext.getAuthExchanges().values()) {
                if (!authExchange.isConnectionBased()) continue;
                authExchange.reset();
            }
            throw exception;
        }
    }

    private boolean needAuthentication(AuthExchange authExchange, AuthExchange authExchange2, HttpHost httpHost, HttpHost httpHost2, String string, HttpResponse httpResponse, HttpClientContext httpClientContext) throws AuthenticationException, MalformedChallengeException {
        RequestConfig requestConfig = httpClientContext.getRequestConfigOrDefault();
        if (requestConfig.isAuthenticationEnabled()) {
            boolean bl2 = this.authenticator.isChallenged(httpHost2, ChallengeType.TARGET, httpResponse, authExchange, httpClientContext);
            boolean bl3 = this.authenticator.isChallengeExpected(authExchange);
            if (this.authCacheKeeper != null) {
                if (bl2) {
                    this.authCacheKeeper.updateOnChallenge(httpHost2, string, authExchange, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(httpHost2, string, authExchange, httpClientContext);
                }
            }
            boolean bl4 = this.authenticator.isChallenged(httpHost, ChallengeType.PROXY, httpResponse, authExchange2, httpClientContext);
            boolean bl5 = this.authenticator.isChallengeExpected(authExchange2);
            if (this.authCacheKeeper != null) {
                if (bl4) {
                    this.authCacheKeeper.updateOnChallenge(httpHost, null, authExchange2, httpClientContext);
                } else {
                    this.authCacheKeeper.updateOnNoChallenge(httpHost, null, authExchange2, httpClientContext);
                }
            }
            if (bl2 || bl3) {
                boolean bl6 = this.authenticator.handleResponse(httpHost2, ChallengeType.TARGET, httpResponse, this.targetAuthStrategy, authExchange, httpClientContext);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(httpHost2, string, authExchange, httpClientContext);
                }
                return bl6;
            }
            if (bl4 || bl5) {
                boolean bl7 = this.authenticator.handleResponse(httpHost, ChallengeType.PROXY, httpResponse, this.proxyAuthStrategy, authExchange2, httpClientContext);
                if (this.authCacheKeeper != null) {
                    this.authCacheKeeper.updateOnResponse(httpHost, null, authExchange2, httpClientContext);
                }
                return bl7;
            }
        }
        return false;
    }
}

