/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;

class RequestEntityProxy
implements HttpEntity {
    private final HttpEntity original;
    private boolean consumed;

    static void enhance(ClassicHttpRequest classicHttpRequest) {
        HttpEntity httpEntity = classicHttpRequest.getEntity();
        if (httpEntity != null && !httpEntity.isRepeatable() && !RequestEntityProxy.isEnhanced(httpEntity)) {
            classicHttpRequest.setEntity(new RequestEntityProxy(httpEntity));
        }
    }

    static boolean isEnhanced(HttpEntity httpEntity) {
        return httpEntity instanceof RequestEntityProxy;
    }

    RequestEntityProxy(HttpEntity httpEntity) {
        this.original = httpEntity;
    }

    public HttpEntity getOriginal() {
        return this.original;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public boolean isRepeatable() {
        return !this.consumed || this.original.isRepeatable();
    }

    @Override
    public boolean isChunked() {
        return this.original.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.original.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.original.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.original.getContentEncoding();
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.original.getContent();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.consumed = true;
        this.original.writeTo(outputStream);
    }

    @Override
    public boolean isStreaming() {
        return this.original.isStreaming();
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return this.original.getTrailers();
    }

    @Override
    public Set<String> getTrailerNames() {
        return this.original.getTrailerNames();
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RequestEntityProxy{");
        stringBuilder.append(this.original);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

