/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncRequestProducer;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncResponseConsumer;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ClassicToAsyncAdaptor
extends CloseableHttpClient {
    private final CloseableHttpAsyncClient client;
    private final Timeout operationTimeout;

    public ClassicToAsyncAdaptor(CloseableHttpAsyncClient closeableHttpAsyncClient, Timeout timeout) {
        this.client = closeableHttpAsyncClient;
        this.operationTimeout = timeout;
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost object, ClassicHttpRequest httpMessage, HttpContext httpContext) throws IOException {
        ClassicToAsyncRequestProducer classicToAsyncRequestProducer = new ClassicToAsyncRequestProducer((ClassicHttpRequest)httpMessage, this.operationTimeout);
        ClassicToAsyncResponseConsumer classicToAsyncResponseConsumer = new ClassicToAsyncResponseConsumer(this.operationTimeout);
        object = this.client.execute((HttpHost)object, classicToAsyncRequestProducer, classicToAsyncResponseConsumer, null, httpContext, null);
        if (httpMessage instanceof CancellableDependency) {
            ((CancellableDependency)((Object)httpMessage)).setDependency(() -> ClassicToAsyncAdaptor.lambda$doExecute$0((Future)object));
        }
        try {
            classicToAsyncRequestProducer.blockWaiting().execute();
            httpMessage = classicToAsyncResponseConsumer.blockWaiting();
            return CloseableHttpResponse.create((ClassicHttpResponse)httpMessage, (arg_0, arg_1) -> ClassicToAsyncAdaptor.lambda$doExecute$1((Future)object, arg_0, arg_1));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.client.close(closeMode);
    }

    private static /* synthetic */ void lambda$doExecute$1(Future future, Closeable closeable, CloseMode closeMode) throws IOException {
        try {
            if (closeMode == CloseMode.GRACEFUL) {
                closeable.close();
            }
            return;
        }
        finally {
            future.cancel(true);
        }
    }

    private static /* synthetic */ boolean lambda$doExecute$0(Future future) {
        return future.cancel(true);
    }
}

