/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncRequestProducer$IORunnable;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncRequestProducer$InternalOutputStream;
import org.apache.hc.client5.http.impl.compat.ClassicToAsyncSupport;
import org.apache.hc.client5.http.impl.compat.SharedOutputBuffer;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Experimental
@Internal
class ClassicToAsyncRequestProducer
implements AsyncRequestProducer {
    private final ClassicHttpRequest request;
    private final int initialBufferSize;
    private final Timeout timeout;
    private final CountDownLatch countDownLatch;
    private final AtomicReference<SharedOutputBuffer> bufferRef;
    private final AtomicReference<Exception> exceptionRef;
    private volatile boolean repeatable;

    public ClassicToAsyncRequestProducer(ClassicHttpRequest classicHttpRequest, int n2, Timeout timeout) {
        this.request = Args.notNull(classicHttpRequest, "HTTP request");
        this.initialBufferSize = Args.positive(n2, "Initial buffer size");
        this.timeout = timeout;
        this.countDownLatch = new CountDownLatch(1);
        this.bufferRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    public ClassicToAsyncRequestProducer(ClassicHttpRequest classicHttpRequest, Timeout timeout) {
        this(classicHttpRequest, 2048, timeout);
    }

    void propagateException() throws IOException {
        Exception exception = this.exceptionRef.getAndSet(null);
        if (exception != null) {
            ClassicToAsyncSupport.rethrow(exception);
        }
    }

    public ClassicToAsyncRequestProducer$IORunnable blockWaiting() throws IOException, InterruptedException {
        if (this.timeout == null) {
            this.countDownLatch.await();
        } else if (!this.countDownLatch.await(this.timeout.getDuration(), this.timeout.getTimeUnit())) {
            throw new InterruptedIOException("Timeout blocked waiting for output (" + this.timeout + ")");
        }
        this.propagateException();
        SharedOutputBuffer sharedOutputBuffer = this.bufferRef.get();
        return () -> {
            Object object2 = this.request.getEntity();
            if (object2 != null) {
                sharedOutputBuffer = new ClassicToAsyncRequestProducer$InternalOutputStream(this, sharedOutputBuffer);
                Throwable throwable = null;
                try {
                    object2.writeTo((OutputStream)((Object)sharedOutputBuffer));
                }
                catch (Throwable throwable2) {
                    try {
                        object2 = throwable2;
                        throwable = throwable2;
                        throw object2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((ClassicToAsyncRequestProducer$InternalOutputStream)((Object)sharedOutputBuffer)).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((ClassicToAsyncRequestProducer$InternalOutputStream)((Object)sharedOutputBuffer)).close();
                        }
                        throw throwable3;
                    }
                }
                ((ClassicToAsyncRequestProducer$InternalOutputStream)((Object)sharedOutputBuffer)).close();
                return;
            }
        };
    }

    @Override
    public void sendRequest(RequestChannel requestChannel, HttpContext object) throws HttpException, IOException {
        object = this.request.getEntity();
        SharedOutputBuffer sharedOutputBuffer = object != null ? new SharedOutputBuffer(this.initialBufferSize) : null;
        this.bufferRef.set(sharedOutputBuffer);
        this.repeatable = object == null || object.isRepeatable();
        requestChannel.sendRequest(this.request, (EntityDetails)object, null);
        this.countDownLatch.countDown();
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    @Override
    public int available() {
        SharedOutputBuffer sharedOutputBuffer = this.bufferRef.get();
        if (sharedOutputBuffer != null) {
            return sharedOutputBuffer.length();
        }
        return 0;
    }

    @Override
    public void produce(DataStreamChannel dataStreamChannel) throws IOException {
        SharedOutputBuffer sharedOutputBuffer = this.bufferRef.get();
        if (sharedOutputBuffer != null) {
            sharedOutputBuffer.flush(dataStreamChannel);
        }
    }

    @Override
    public void failed(Exception exception) {
        try {
            this.exceptionRef.set(exception);
            return;
        }
        finally {
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void releaseResources() {
    }

    static /* synthetic */ Timeout access$000(ClassicToAsyncRequestProducer classicToAsyncRequestProducer) {
        return classicToAsyncRequestProducer.timeout;
    }
}

