/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.compat;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.impl.compat.AbstractSharedBuffer;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.support.classic.ContentOutputBuffer;
import org.apache.hc.core5.util.Timeout;

@Internal
final class SharedOutputBuffer
extends AbstractSharedBuffer
implements ContentOutputBuffer {
    private final AtomicBoolean endStreamPropagated = new AtomicBoolean();
    private volatile DataStreamChannel dataStreamChannel;
    private volatile boolean hasCapacity = false;

    public SharedOutputBuffer(ReentrantLock reentrantLock, int n2) {
        super(reentrantLock, n2);
    }

    public SharedOutputBuffer(int n2) {
        this(new ReentrantLock(), n2);
    }

    public final void flush(DataStreamChannel dataStreamChannel) throws IOException {
        this.lock.lock();
        try {
            this.dataStreamChannel = dataStreamChannel;
            this.hasCapacity = true;
            this.setOutputMode();
            if (this.buffer().hasRemaining()) {
                this.dataStreamChannel.write(this.buffer());
            }
            if (!this.buffer().hasRemaining() && this.endStream) {
                this.propagateEndStream();
            }
            this.condition.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ensureNotAborted() throws InterruptedIOException {
        if (this.aborted) {
            throw new InterruptedIOException("Operation aborted");
        }
    }

    public final void write(byte[] object, int n2, int n3, Timeout timeout) throws IOException {
        object = ByteBuffer.wrap((byte[])object, n2, n3);
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            while (((Buffer)object).hasRemaining()) {
                if (((Buffer)object).remaining() < 1024 && this.buffer().remaining() > ((Buffer)object).remaining()) {
                    this.buffer().put((ByteBuffer)object);
                    continue;
                }
                if (this.buffer().position() > 0 || this.dataStreamChannel == null) {
                    this.waitFlush(timeout);
                }
                if (this.buffer().position() != 0 || this.dataStreamChannel == null || (n2 = this.dataStreamChannel.write((ByteBuffer)object)) != 0) continue;
                this.hasCapacity = false;
                this.waitFlush(timeout);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        this.write(byArray, n2, n3, null);
    }

    public final void write(int n2, Timeout timeout) throws IOException {
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            if (!this.buffer().hasRemaining()) {
                this.waitFlush(timeout);
            }
            this.buffer().put((byte)n2);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void write(int n2) throws IOException {
        this.write(n2, null);
    }

    public final void writeCompleted(Timeout timeout) throws IOException {
        if (this.endStream) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.endStream) {
                this.endStream = true;
                if (this.dataStreamChannel != null) {
                    this.setOutputMode();
                    if (this.buffer().hasRemaining()) {
                        this.dataStreamChannel.requestOutput();
                        this.waitEndStream(timeout);
                    } else {
                        this.propagateEndStream();
                    }
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void writeCompleted() throws IOException {
        this.writeCompleted(null);
    }

    private void waitFlush(Timeout timeout) throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        this.setOutputMode();
        while (this.buffer().hasRemaining() || !this.hasCapacity) {
            this.ensureNotAborted();
            this.waitForSignal(timeout);
        }
        this.setInputMode();
    }

    private void waitEndStream(Timeout timeout) throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        while (!this.endStreamPropagated.get() && !this.aborted) {
            this.waitForSignal(timeout);
        }
    }

    private void waitForSignal(Timeout timeout) throws InterruptedIOException {
        try {
            if (timeout != null) {
                if (!this.condition.await(timeout.getDuration(), timeout.getTimeUnit())) {
                    this.aborted = true;
                    throw new InterruptedIOException("Timeout blocked waiting for output (" + timeout + ")");
                }
                return;
            }
            this.condition.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(interruptedException.getMessage());
        }
    }

    private void propagateEndStream() throws IOException {
        if (this.endStreamPropagated.compareAndSet(false, true)) {
            this.dataStreamChannel.endStream();
        }
    }
}

