/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.util.Args;

public final class BasicClientCookie
implements Serializable,
Cloneable,
SetCookie {
    private static final long serialVersionUID = -3869795591041535538L;
    private final String name;
    private Map<String, String> attribs;
    private String value;
    private String cookieDomain;
    private Instant cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private Instant creationDate;
    private boolean httpOnly;

    public BasicClientCookie(String string, String string2) {
        Args.notNull(string, "Name");
        this.name = string;
        this.attribs = new HashMap<String, String>();
        this.value = string2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final void setValue(String string) {
        this.value = string;
    }

    @Override
    @Deprecated
    public final Date getExpiryDate() {
        return DateUtils.toDate(this.cookieExpiryDate);
    }

    @Override
    public final Instant getExpiryInstant() {
        return this.cookieExpiryDate;
    }

    @Override
    @Deprecated
    public final void setExpiryDate(Date date) {
        this.cookieExpiryDate = DateUtils.toInstant(date);
    }

    @Override
    public final void setExpiryDate(Instant instant) {
        this.cookieExpiryDate = instant;
    }

    @Override
    public final boolean isPersistent() {
        return this.cookieExpiryDate != null;
    }

    @Override
    public final String getDomain() {
        return this.cookieDomain;
    }

    @Override
    public final void setDomain(String string) {
        if (string != null) {
            this.cookieDomain = string.toLowerCase(Locale.ROOT);
            return;
        }
        this.cookieDomain = null;
    }

    @Override
    public final String getPath() {
        return this.cookiePath;
    }

    @Override
    public final void setPath(String string) {
        this.cookiePath = string;
    }

    @Override
    public final boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public final void setSecure(boolean bl2) {
        this.isSecure = bl2;
    }

    @Override
    public final void setHttpOnly(boolean bl2) {
        this.httpOnly = bl2;
    }

    @Override
    @Deprecated
    public final boolean isExpired(Date date) {
        Args.notNull(date, "Date");
        return this.cookieExpiryDate != null && this.cookieExpiryDate.compareTo(DateUtils.toInstant(date)) <= 0;
    }

    @Override
    public final boolean isExpired(Instant instant) {
        Args.notNull(instant, "Instant");
        return this.cookieExpiryDate != null && this.cookieExpiryDate.compareTo(instant) <= 0;
    }

    @Override
    @Deprecated
    public final Date getCreationDate() {
        return DateUtils.toDate(this.creationDate);
    }

    @Override
    public final Instant getCreationInstant() {
        return this.creationDate;
    }

    @Override
    public final boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Deprecated
    public final void setCreationDate(Date date) {
        this.creationDate = DateUtils.toInstant(date);
    }

    public final void setCreationDate(Instant instant) {
        this.creationDate = instant;
    }

    public final void setAttribute(String string, String string2) {
        this.attribs.put(string, string2);
    }

    @Override
    public final String getAttribute(String string) {
        return this.attribs.get(string);
    }

    @Override
    public final boolean containsAttribute(String string) {
        return this.attribs.containsKey(string);
    }

    public final boolean removeAttribute(String string) {
        return this.attribs.remove(string) != null;
    }

    public final Object clone() throws CloneNotSupportedException {
        BasicClientCookie basicClientCookie = (BasicClientCookie)super.clone();
        ((BasicClientCookie)super.clone()).attribs = new HashMap<String, String>(this.attribs);
        return basicClientCookie;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[name: ");
        stringBuilder.append(this.name);
        stringBuilder.append("; ");
        stringBuilder.append("value: ");
        stringBuilder.append(this.value);
        stringBuilder.append("; ");
        stringBuilder.append("domain: ");
        stringBuilder.append(this.cookieDomain);
        stringBuilder.append("; ");
        stringBuilder.append("path: ");
        stringBuilder.append(this.cookiePath);
        stringBuilder.append("; ");
        stringBuilder.append("expiry: ");
        stringBuilder.append(this.cookieExpiryDate);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

