/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.Locale;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieRestrictionViolationException;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    public static final BasicDomainHandler INSTANCE = new BasicDomainHandler();

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (string.endsWith(".")) {
            return;
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        string = string.toLowerCase(Locale.ROOT);
        setCookie.setDomain(string);
    }

    @Override
    public void validate(Cookie object, CookieOrigin object2) throws MalformedCookieException {
        Args.notNull(object, "Cookie");
        Args.notNull(object2, "Cookie origin");
        object2 = ((CookieOrigin)object2).getHost();
        object = object.getDomain();
        if (object == null) {
            throw new CookieRestrictionViolationException("Cookie 'domain' may not be null");
        }
        if (!((String)object2).equals(object) && !BasicDomainHandler.domainMatch((String)object, (String)object2)) {
            throw new CookieRestrictionViolationException("Illegal 'domain' attribute \"" + (String)object + "\". Domain of origin: \"" + (String)object2 + "\"");
        }
    }

    static boolean domainMatch(String string, String string2) {
        if (InetAddressUtils.isIPv4(string2) || InetAddressUtils.isIPv6(string2)) {
            return false;
        }
        String string3 = string = string.startsWith(".") ? string.substring(1) : string;
        if (string2.endsWith(string)) {
            int n2 = string2.length() - string.length();
            if (n2 == 0) {
                return true;
            }
            return n2 > 1 && string2.charAt(n2 - 1) == '.';
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin object) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(object, "Cookie origin");
        object = ((CookieOrigin)object).getHost();
        String string = cookie.getDomain();
        if (string == null) {
            return false;
        }
        if (string.startsWith(".")) {
            string = string.substring(1);
        }
        if (((String)object).equals(string = string.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie.containsAttribute("domain")) {
            return BasicDomainHandler.domainMatch(string, (String)object);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

