/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public static final BasicMaxAgeHandler INSTANCE = new BasicMaxAgeHandler();

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        int n2;
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + string);
        }
        if (n2 < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + string);
        }
        setCookie.setExpiryDate(Instant.now().plusSeconds(n2));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

