/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicPathHandler
implements CommonCookieAttributeHandler {
    public static final BasicPathHandler INSTANCE = new BasicPathHandler();

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        setCookie.setPath(!TextUtils.isBlank(string) ? string : "/");
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
    }

    static boolean pathMatch(String string, String string2) {
        if (string2 == null) {
            string2 = "/";
        }
        if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string.startsWith(string2)) {
            if (string2.equals("/")) {
                return true;
            }
            if (string.length() == string2.length()) {
                return true;
            }
            return string.charAt(string2.length()) == '/';
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        return BasicPathHandler.pathMatch(cookieOrigin.getPath(), cookie.getPath());
    }

    @Override
    public String getAttributeName() {
        return "path";
    }
}

