/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.Serializable;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.BitSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer$Cursor;

@Contract(threading=ThreadingBehavior.STATELESS)
public class LaxExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public static final LaxExpiresHandler INSTANCE;
    private static final BitSet DELIMS;
    private static final Map<String, Month> MONTHS;
    private static final Pattern TIME_PATTERN;
    private static final Pattern DAY_OF_MONTH_PATTERN;
    private static final Pattern MONTH_PATTERN;
    private static final Pattern YEAR_PATTERN;

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Object object;
        Args.notNull(setCookie, "Cookie");
        if (TextUtils.isBlank(string)) {
            return;
        }
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Month month = Month.JANUARY;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            while (!tokenizer$Cursor.atEnd()) {
                this.skipDelims(string, tokenizer$Cursor);
                stringBuilder.setLength(0);
                this.copyContent(string, tokenizer$Cursor, stringBuilder);
                if (stringBuilder.length() != 0) {
                    if (!bl2 && ((Matcher)(object = TIME_PATTERN.matcher(stringBuilder))).matches()) {
                        bl2 = true;
                        n4 = Integer.parseInt(((Matcher)object).group(1));
                        n3 = Integer.parseInt(((Matcher)object).group(2));
                        n2 = Integer.parseInt(((Matcher)object).group(3));
                        continue;
                    }
                    if (!bl3 && ((Matcher)(object = DAY_OF_MONTH_PATTERN.matcher(stringBuilder))).matches()) {
                        bl3 = true;
                        n5 = Integer.parseInt(((Matcher)object).group(1));
                        continue;
                    }
                    if (!bl4 && ((Matcher)(object = MONTH_PATTERN.matcher(stringBuilder))).matches()) {
                        bl4 = true;
                        month = MONTHS.get(((Matcher)object).group(1).toLowerCase(Locale.ROOT));
                        continue;
                    }
                    if (bl5 || !((Matcher)(object = YEAR_PATTERN.matcher(stringBuilder))).matches()) continue;
                    bl5 = true;
                    n6 = Integer.parseInt(((Matcher)object).group(1));
                    continue;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        if (!(bl2 && bl3 && bl4 && bl5)) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        if (n6 >= 70 && n6 <= 99) {
            n6 += 1900;
        }
        if (n6 >= 0 && n6 <= 69) {
            n6 += 2000;
        }
        if (n5 <= 0 || n5 > 31 || n6 < 1601 || n4 > 23 || n3 > 59 || n2 > 59) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + string);
        }
        object = ZonedDateTime.of(n6, month.getValue(), n5, n4, n3, n2, 0, ZoneId.of("UTC")).toInstant();
        setCookie.setExpiryDate((Instant)object);
    }

    private void skipDelims(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor) {
        char c2;
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        while (n3 < n4 && DELIMS.get(c2 = charSequence.charAt(n3))) {
            ++n2;
            ++n3;
        }
        tokenizer$Cursor.updatePos(n2);
    }

    private void copyContent(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, StringBuilder stringBuilder) {
        char c2;
        int n2 = tokenizer$Cursor.getPos();
        int n3 = tokenizer$Cursor.getPos();
        int n4 = tokenizer$Cursor.getUpperBound();
        while (n3 < n4 && !DELIMS.get(c2 = charSequence.charAt(n3))) {
            ++n2;
            stringBuilder.append(c2);
            ++n3;
        }
        tokenizer$Cursor.updatePos(n2);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }

    static {
        int n2;
        INSTANCE = new LaxExpiresHandler();
        Serializable serializable = new BitSet();
        ((BitSet)serializable).set(9);
        for (n2 = 32; n2 <= 47; ++n2) {
            ((BitSet)serializable).set(n2);
        }
        for (n2 = 59; n2 <= 64; ++n2) {
            ((BitSet)serializable).set(n2);
        }
        for (n2 = 91; n2 <= 96; ++n2) {
            ((BitSet)serializable).set(n2);
        }
        for (n2 = 123; n2 <= 126; ++n2) {
            ((BitSet)serializable).set(n2);
        }
        DELIMS = serializable;
        serializable = new ConcurrentHashMap<String, Month>(12);
        ((ConcurrentHashMap)serializable).put("jan", Month.JANUARY);
        ((ConcurrentHashMap)serializable).put("feb", Month.FEBRUARY);
        ((ConcurrentHashMap)serializable).put("mar", Month.MARCH);
        ((ConcurrentHashMap)serializable).put("apr", Month.APRIL);
        ((ConcurrentHashMap)serializable).put("may", Month.MAY);
        ((ConcurrentHashMap)serializable).put("jun", Month.JUNE);
        ((ConcurrentHashMap)serializable).put("jul", Month.JULY);
        ((ConcurrentHashMap)serializable).put("aug", Month.AUGUST);
        ((ConcurrentHashMap)serializable).put("sep", Month.SEPTEMBER);
        ((ConcurrentHashMap)serializable).put("oct", Month.OCTOBER);
        ((ConcurrentHashMap)serializable).put("nov", Month.NOVEMBER);
        ((ConcurrentHashMap)serializable).put("dec", Month.DECEMBER);
        MONTHS = serializable;
        TIME_PATTERN = Pattern.compile("^([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})([^0-9].*)?$");
        DAY_OF_MONTH_PATTERN = Pattern.compile("^([0-9]{1,2})([^0-9].*)?$");
        MONTH_PATTERN = Pattern.compile("^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)(.*)?$", 2);
        YEAR_PATTERN = Pattern.compile("^([0-9]{2,4})([^0-9].*)?$");
    }
}

