/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PublicSuffixDomainFilter.class);
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final Map<String, Boolean> localDomainMap;

    private static Map<String, Boolean> createLocalDomainMap() {
        ConcurrentHashMap<String, Boolean> concurrentHashMap = new ConcurrentHashMap<String, Boolean>();
        concurrentHashMap.put(".localhost.", Boolean.TRUE);
        concurrentHashMap.put(".test.", Boolean.TRUE);
        concurrentHashMap.put(".local.", Boolean.TRUE);
        concurrentHashMap.put(".local", Boolean.TRUE);
        concurrentHashMap.put(".localdomain", Boolean.TRUE);
        return concurrentHashMap;
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler commonCookieAttributeHandler, PublicSuffixMatcher publicSuffixMatcher) {
        this.handler = Args.notNull(commonCookieAttributeHandler, "Cookie handler");
        this.publicSuffixMatcher = Args.notNull(publicSuffixMatcher, "Public suffix matcher");
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    public PublicSuffixDomainFilter(CommonCookieAttributeHandler commonCookieAttributeHandler, PublicSuffixList publicSuffixList) {
        Args.notNull(commonCookieAttributeHandler, "Cookie handler");
        Args.notNull(publicSuffixList, "Public suffix list");
        this.handler = commonCookieAttributeHandler;
        this.publicSuffixMatcher = new PublicSuffixMatcher(publicSuffixList.getRules(), publicSuffixList.getExceptions());
        this.localDomainMap = PublicSuffixDomainFilter.createLocalDomainMap();
    }

    private boolean verifyHost(String string) {
        if (this.publicSuffixMatcher.verify(string)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Public Suffix List verification failed for host '{}'", (Object)string);
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        String string;
        String string2 = cookie.getDomain();
        if (string2 == null) {
            return false;
        }
        int n2 = string2.indexOf(46);
        if (n2 >= 0 ? !this.localDomainMap.containsKey(string = string2.substring(n2)) && !this.verifyHost(string2) : !string2.equalsIgnoreCase(cookieOrigin.getHost()) && !this.verifyHost(string2)) {
            return false;
        }
        return this.handler.match(cookie, cookieOrigin);
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        this.handler.parse(setCookie, string);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        this.handler.validate(cookie, cookieOrigin);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler commonCookieAttributeHandler, PublicSuffixMatcher publicSuffixMatcher) {
        Args.notNull(commonCookieAttributeHandler, "Cookie attribute handler");
        if (publicSuffixMatcher != null) {
            return new PublicSuffixDomainFilter(commonCookieAttributeHandler, publicSuffixMatcher);
        }
        return commonCookieAttributeHandler;
    }
}

