/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieAttributeHandler;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookiePriorityComparator;
import org.apache.hc.client5.http.cookie.CookieSpec;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.SAFE)
public class RFC6265CookieSpec
implements CookieSpec {
    private static final char PARAM_DELIMITER = ';';
    private static final char COMMA_CHAR = ',';
    private static final char EQUAL_CHAR = '=';
    private static final char DQUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final Tokenizer$Delimiter TOKEN_DELIMS = Tokenizer.delimiters('=', ';');
    private static final Tokenizer$Delimiter VALUE_DELIMS = Tokenizer.delimiters(';');
    private static final Tokenizer$Delimiter SPECIAL_CHARS = Tokenizer.delimiters(' ', '\"', ',', ';', '\\');
    private final CookieAttributeHandler[] attribHandlers;
    private final Map<String, CookieAttributeHandler> attribHandlerMap;
    private final Tokenizer tokenParser;

    protected RFC6265CookieSpec(CommonCookieAttributeHandler ... commonCookieAttributeHandlerArray) {
        this.attribHandlers = (CookieAttributeHandler[])commonCookieAttributeHandlerArray.clone();
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(commonCookieAttributeHandlerArray.length);
        for (CommonCookieAttributeHandler commonCookieAttributeHandler : commonCookieAttributeHandlerArray) {
            this.attribHandlerMap.put(commonCookieAttributeHandler.getAttributeName().toLowerCase(Locale.ROOT), commonCookieAttributeHandler);
        }
        this.tokenParser = Tokenizer.INSTANCE;
    }

    static String getDefaultPath(CookieOrigin object) {
        int n2 = ((String)(object = ((CookieOrigin)object).getPath())).lastIndexOf(47);
        if (n2 >= 0) {
            if (n2 == 0) {
                n2 = 1;
            }
            object = ((String)object).substring(0, n2);
        }
        return object;
    }

    static String getDefaultDomain(CookieOrigin cookieOrigin) {
        return cookieOrigin.getHost();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Cookie> parse(Header object, CookieOrigin object2) throws MalformedCookieException {
        Object object3;
        Tokenizer$Cursor tokenizer$Cursor;
        Object object4;
        Args.notNull(object, "Header");
        Args.notNull(object2, "Cookie origin");
        if (!object.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header: '" + object + "'");
        }
        if (object instanceof FormattedHeader) {
            object4 = ((FormattedHeader)object).getBuffer();
            tokenizer$Cursor = new Tokenizer$Cursor(((FormattedHeader)object).getValuePos(), ((CharArrayBuffer)object4).length());
        } else {
            object3 = object.getValue();
            if (object3 == null) {
                throw new MalformedCookieException("Header value is null");
            }
            object4 = new CharArrayBuffer(((String)object3).length());
            ((CharArrayBuffer)object4).append((String)object3);
            tokenizer$Cursor = new Tokenizer$Cursor(0, ((CharArrayBuffer)object4).length());
        }
        object3 = this.tokenParser.parseToken((CharSequence)object4, tokenizer$Cursor, TOKEN_DELIMS);
        if (((String)object3).isEmpty()) {
            return Collections.emptyList();
        }
        if (tokenizer$Cursor.atEnd()) {
            return Collections.emptyList();
        }
        char c2 = ((CharArrayBuffer)object4).charAt(tokenizer$Cursor.getPos());
        Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
        tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
        if (c2 != '=') {
            throw new MalformedCookieException("Cookie value is invalid: '" + object + "'");
        }
        object = this.tokenParser.parseValue((CharSequence)object4, tokenizer$Cursor, VALUE_DELIMS);
        if (!tokenizer$Cursor.atEnd()) {
            Tokenizer$Cursor tokenizer$Cursor3 = tokenizer$Cursor;
            tokenizer$Cursor3.updatePos(tokenizer$Cursor3.getPos() + 1);
        }
        object = new BasicClientCookie((String)object3, (String)object);
        ((BasicClientCookie)object).setPath(RFC6265CookieSpec.getDefaultPath((CookieOrigin)object2));
        ((BasicClientCookie)object).setDomain(RFC6265CookieSpec.getDefaultDomain((CookieOrigin)object2));
        ((BasicClientCookie)object).setCreationDate(Instant.now());
        object2 = new LinkedHashMap<Object, void>();
        while (!tokenizer$Cursor.atEnd()) {
            void var6_9;
            object3 = this.tokenParser.parseToken((CharSequence)object4, tokenizer$Cursor, TOKEN_DELIMS).toLowerCase(Locale.ROOT);
            Object string = null;
            if (!tokenizer$Cursor.atEnd()) {
                char c3 = ((CharArrayBuffer)object4).charAt(tokenizer$Cursor.getPos());
                Tokenizer$Cursor tokenizer$Cursor4 = tokenizer$Cursor;
                tokenizer$Cursor4.updatePos(tokenizer$Cursor4.getPos() + 1);
                if (c3 == '=') {
                    String entry = this.tokenParser.parseToken((CharSequence)object4, tokenizer$Cursor, VALUE_DELIMS);
                    if (!tokenizer$Cursor.atEnd()) {
                        Tokenizer$Cursor tokenizer$Cursor5 = tokenizer$Cursor;
                        tokenizer$Cursor5.updatePos(tokenizer$Cursor5.getPos() + 1);
                    }
                }
            }
            ((BasicClientCookie)object).setAttribute((String)object3, (String)var6_9);
            object2.put(object3, var6_9);
        }
        if (object2.containsKey("max-age")) {
            object2.remove("expires");
        }
        for (Map.Entry entry : object2.entrySet()) {
            String string = (String)entry.getKey();
            object2 = (String)entry.getValue();
            object4 = this.attribHandlerMap.get(string);
            if (object4 == null) continue;
            object4.parse((SetCookie)object, (String)object2);
        }
        return Collections.singletonList(object);
    }

    @Override
    public final void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        CookieAttributeHandler[] cookieAttributeHandlerArray = this.attribHandlers;
        int n2 = this.attribHandlers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CookieAttributeHandler cookieAttributeHandler = cookieAttributeHandlerArray[i2];
            cookieAttributeHandler.validate(cookie, cookieOrigin);
        }
    }

    @Override
    public final boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        CookieAttributeHandler[] cookieAttributeHandlerArray = this.attribHandlers;
        int n2 = this.attribHandlers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CookieAttributeHandler cookieAttributeHandler = cookieAttributeHandlerArray[i2];
            if (cookieAttributeHandler.match(cookie, cookieOrigin)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Header> formatCookies(List<Cookie> list) {
        Args.notEmpty(list, "List of cookies");
        if (list.size() > 1) {
            list = new ArrayList<Cookie>(list);
            list.sort(CookiePriorityComparator.INSTANCE);
        }
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(20 * list.size());
        charArrayBuffer.append("Cookie");
        charArrayBuffer.append(": ");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (i2 > 0) {
                charArrayBuffer.append(';');
                charArrayBuffer.append(' ');
            }
            charArrayBuffer.append(object.getName());
            object = object.getValue();
            if (object == null) continue;
            charArrayBuffer.append('=');
            if (this.containsSpecialChar((CharSequence)object)) {
                charArrayBuffer.append('\"');
                for (int i3 = 0; i3 < ((String)object).length(); ++i3) {
                    char c2 = ((String)object).charAt(i3);
                    if (c2 == '\"' || c2 == '\\') {
                        charArrayBuffer.append('\\');
                    }
                    charArrayBuffer.append(c2);
                }
                charArrayBuffer.append('\"');
                continue;
            }
            charArrayBuffer.append((String)object);
        }
        ArrayList<Header> arrayList = new ArrayList<Header>(1);
        try {
            arrayList.add(new BufferedHeader(charArrayBuffer));
        }
        catch (ParseException parseException) {}
        return arrayList;
    }

    boolean containsSpecialChar(CharSequence charSequence) {
        return this.containsChars(charSequence, SPECIAL_CHARS);
    }

    boolean containsChars(CharSequence charSequence, Tokenizer$Delimiter tokenizer$Delimiter) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (!tokenizer$Delimiter.test(c2)) continue;
            return true;
        }
        return false;
    }
}

