/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.ConnectionHolder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.ConnectionEndpoint$RequestExecutor;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

class BasicHttpClientConnectionManager$InternalConnectionEndpoint
extends ConnectionEndpoint
implements ConnectionHolder,
Identifiable {
    private final HttpRoute route;
    private final AtomicReference<ManagedHttpClientConnection> connRef;
    final /* synthetic */ BasicHttpClientConnectionManager this$0;

    public BasicHttpClientConnectionManager$InternalConnectionEndpoint(BasicHttpClientConnectionManager basicHttpClientConnectionManager, HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection) {
        this.this$0 = basicHttpClientConnectionManager;
        this.route = httpRoute;
        this.connRef = new AtomicReference<ManagedHttpClientConnection>(managedHttpClientConnection);
    }

    @Override
    public String getId() {
        return BasicHttpClientConnectionManager.access$000(this.this$0);
    }

    HttpRoute getRoute() {
        return this.route;
    }

    ManagedHttpClientConnection getConnection() {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        if (managedHttpClientConnection == null) {
            throw new ConnectionShutdownException();
        }
        return managedHttpClientConnection;
    }

    ManagedHttpClientConnection getValidatedConnection() {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        if (managedHttpClientConnection == null || !managedHttpClientConnection.isOpen()) {
            throw new ConnectionShutdownException();
        }
        return managedHttpClientConnection;
    }

    ManagedHttpClientConnection detach() {
        return this.connRef.getAndSet(null);
    }

    @Override
    public boolean isConnected() {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        return managedHttpClientConnection != null && managedHttpClientConnection.isOpen();
    }

    @Override
    public void close(CloseMode closeMode) {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        if (managedHttpClientConnection != null) {
            managedHttpClientConnection.close(closeMode);
        }
    }

    @Override
    public void close() throws IOException {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        if (managedHttpClientConnection != null) {
            managedHttpClientConnection.close();
        }
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.getValidatedConnection().setSocketTimeout(timeout);
    }

    @Override
    @Deprecated
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest, HttpRequestExecutor httpRequestExecutor, HttpContext httpContext) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(httpRequestExecutor, "Request executor");
        if (BasicHttpClientConnectionManager.access$100().isDebugEnabled()) {
            BasicHttpClientConnectionManager.access$100().debug("{} Executing exchange {}", (Object)BasicHttpClientConnectionManager.access$000(this.this$0), (Object)string);
        }
        return httpRequestExecutor.execute(classicHttpRequest, this.getValidatedConnection(), httpContext);
    }

    @Override
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest, ConnectionEndpoint$RequestExecutor connectionEndpoint$RequestExecutor, HttpContext httpContext) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(connectionEndpoint$RequestExecutor, "Request executor");
        if (BasicHttpClientConnectionManager.access$100().isDebugEnabled()) {
            BasicHttpClientConnectionManager.access$100().debug("{} Executing exchange {}", (Object)BasicHttpClientConnectionManager.access$000(this.this$0), (Object)string);
        }
        return connectionEndpoint$RequestExecutor.execute(classicHttpRequest, this.getValidatedConnection(), httpContext);
    }

    @Override
    public EndpointInfo getInfo() {
        ManagedHttpClientConnection managedHttpClientConnection = this.connRef.get();
        if (managedHttpClientConnection != null && managedHttpClientConnection.isOpen()) {
            return new EndpointInfo(managedHttpClientConnection.getProtocolVersion(), managedHttpClientConnection.getSSLSession());
        }
        return null;
    }

    @Override
    public HttpConnection get() {
        return this.connRef.get();
    }
}

