/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager$1;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager$InternalConnectionEndpoint;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicHttpClientConnectionManager
implements HttpClientConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpClientConnectionManager.class);
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final String id;
    private final ReentrantLock lock;
    private ManagedHttpClientConnection conn;
    private HttpRoute route;
    private Object state;
    private long created;
    private long updated;
    private long expiry;
    private boolean leased;
    private SocketConfig socketConfig;
    private ConnectionConfig connectionConfig;
    private TlsConfig tlsConfig;
    private final AtomicBoolean closed;

    public BasicHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<ManagedHttpClientConnection> managedHttpClientConnectionFactory) {
        this.connectionOperator = Args.notNull(httpClientConnectionOperator, "Connection operator");
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.id = String.format("ep-%010d", COUNT.getAndIncrement());
        this.expiry = Long.MAX_VALUE;
        this.socketConfig = SocketConfig.DEFAULT;
        this.connectionConfig = ConnectionConfig.DEFAULT;
        this.tlsConfig = TlsConfig.DEFAULT;
        this.closed = new AtomicBoolean(false);
        this.lock = new ReentrantLock();
    }

    public static BasicHttpClientConnectionManager create(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsSocketStrategy> lookup, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(schemePortResolver, dnsResolver, lookup), httpConnectionFactory);
    }

    public static BasicHttpClientConnectionManager create(Lookup<TlsSocketStrategy> lookup, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(null, null, lookup), httpConnectionFactory);
    }

    public static BasicHttpClientConnectionManager create(Lookup<TlsSocketStrategy> lookup) {
        return new BasicHttpClientConnectionManager(new DefaultHttpClientConnectionOperator(null, null, lookup), null);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultHttpClientConnectionOperator(lookup, schemePortResolver, dnsResolver), httpConnectionFactory);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        this(lookup, httpConnectionFactory, null, null);
    }

    @Deprecated
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> lookup) {
        this(lookup, null, null, null);
    }

    public BasicHttpClientConnectionManager() {
        this(new DefaultHttpClientConnectionOperator(null, null, RegistryBuilder.create().register(URIScheme.HTTPS.id, DefaultClientTlsStrategy.createDefault()).build()), null);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection(closeMode);
        }
    }

    HttpRoute getRoute() {
        return this.route;
    }

    Object getState() {
        return this.state;
    }

    public SocketConfig getSocketConfig() {
        this.lock.lock();
        try {
            SocketConfig socketConfig = this.socketConfig;
            return socketConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSocketConfig(SocketConfig socketConfig) {
        this.lock.lock();
        try {
            this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ConnectionConfig getConnectionConfig() {
        this.lock.lock();
        try {
            ConnectionConfig connectionConfig = this.connectionConfig;
            return connectionConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setConnectionConfig(ConnectionConfig connectionConfig) {
        this.lock.lock();
        try {
            this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TlsConfig getTlsConfig() {
        this.lock.lock();
        try {
            TlsConfig tlsConfig = this.tlsConfig;
            return tlsConfig;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.lock.lock();
        try {
            this.tlsConfig = tlsConfig != null ? tlsConfig : TlsConfig.DEFAULT;
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LeaseRequest lease(String string, HttpRoute httpRoute, Object object) {
        return this.lease(string, httpRoute, Timeout.DISABLED, object);
    }

    @Override
    public LeaseRequest lease(String string, HttpRoute httpRoute, Timeout timeout, Object object) {
        return new BasicHttpClientConnectionManager$1(this, httpRoute, object);
    }

    private void closeConnection(CloseMode closeMode) {
        this.lock.lock();
        try {
            if (this.conn != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Closing connection {}", (Object)this.id, (Object)closeMode);
                }
                this.conn.close(closeMode);
                this.conn = null;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkExpiry() {
        if (this.conn != null && System.currentTimeMillis() >= this.expiry) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection expired @ {}", (Object)this.id, (Object)Instant.ofEpochMilli(this.expiry));
            }
            this.closeConnection(CloseMode.GRACEFUL);
        }
    }

    private void validate() {
        Object object;
        if (this.conn != null && TimeValue.isNonNegative((TimeValue)(object = this.connectionConfig.getTimeToLive())) && ((Deadline)(object = Deadline.calculate(this.created, (TimeValue)object))).isExpired()) {
            this.closeConnection(CloseMode.GRACEFUL);
        }
        if (this.conn != null && TimeValue.isNonNegative((TimeValue)(object = this.connectionConfig.getValidateAfterInactivity() != null ? this.connectionConfig.getValidateAfterInactivity() : TimeValue.ofSeconds(2L))) && ((Deadline)(object = Deadline.calculate(this.updated, (TimeValue)object))).isExpired()) {
            boolean bl2;
            try {
                bl2 = this.conn.isStale();
            }
            catch (IOException iOException) {
                bl2 = true;
            }
            if (bl2) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} connection {} is stale", (Object)this.id, (Object)ConnPoolSupport.getId(this.conn));
                }
                this.closeConnection(CloseMode.GRACEFUL);
            }
        }
    }

    ManagedHttpClientConnection getConnection(HttpRoute object, Object object2) throws IOException {
        this.lock.lock();
        try {
            Asserts.check(!this.isClosed(), "Connection manager has been shut down");
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Get connection for route {}", (Object)this.id, object);
            }
            Asserts.check(!this.leased, "Connection %s is still allocated", (Object)this.conn);
            if (!Objects.equals(this.route, object) || !Objects.equals(this.state, object2)) {
                this.closeConnection(CloseMode.GRACEFUL);
            }
            this.route = object;
            this.state = object2;
            this.checkExpiry();
            this.validate();
            if (this.conn == null) {
                this.conn = this.connFactory.createConnection(null);
                this.created = System.currentTimeMillis();
            } else {
                this.conn.activate();
                if (this.connectionConfig.getSocketTimeout() != null) {
                    this.conn.setSocketTimeout(this.connectionConfig.getSocketTimeout());
                }
            }
            this.leased = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Using connection {}", (Object)this.id, (Object)this.conn);
            }
            object = this.conn;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private BasicHttpClientConnectionManager$InternalConnectionEndpoint cast(ConnectionEndpoint connectionEndpoint) {
        if (connectionEndpoint instanceof BasicHttpClientConnectionManager$InternalConnectionEndpoint) {
            return (BasicHttpClientConnectionManager$InternalConnectionEndpoint)connectionEndpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + connectionEndpoint.getClass());
    }

    @Override
    public void release(ConnectionEndpoint modalCloseable, Object object, TimeValue timeValue) {
        this.lock.lock();
        try {
            Args.notNull(modalCloseable, "Managed endpoint");
            modalCloseable = this.cast((ConnectionEndpoint)modalCloseable);
            modalCloseable = ((BasicHttpClientConnectionManager$InternalConnectionEndpoint)modalCloseable).detach();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Releasing connection {}", (Object)this.id, (Object)modalCloseable);
            }
            if (this.isClosed()) {
                return;
            }
            try {
                if (timeValue == null && modalCloseable != null) {
                    modalCloseable.close(CloseMode.GRACEFUL);
                }
                this.updated = System.currentTimeMillis();
                if (modalCloseable != null && modalCloseable.isOpen() && modalCloseable.isConsistent()) {
                    this.state = object;
                    modalCloseable.passivate();
                    if (TimeValue.isPositive(timeValue)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} Connection can be kept alive for {}", (Object)this.id, (Object)timeValue);
                        }
                        this.expiry = this.updated + timeValue.toMilliseconds();
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} Connection can be kept alive indefinitely", (Object)this.id);
                        }
                        this.expiry = Long.MAX_VALUE;
                    }
                } else {
                    this.route = null;
                    this.conn = null;
                    this.expiry = Long.MAX_VALUE;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} Connection is not kept alive", (Object)this.id);
                    }
                }
            }
            finally {
                this.leased = false;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connect(ConnectionEndpoint object, TimeValue timeValue, HttpContext httpContext) throws IOException {
        this.lock.lock();
        try {
            Args.notNull(object, "Endpoint");
            ModalCloseable modalCloseable = this.cast((ConnectionEndpoint)object);
            if (((ConnectionEndpoint)modalCloseable).isConnected()) {
                return;
            }
            HttpRoute httpRoute = ((BasicHttpClientConnectionManager$InternalConnectionEndpoint)modalCloseable).getRoute();
            HttpHost httpHost = httpRoute.getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
            timeValue = timeValue != null ? Timeout.of(timeValue.getDuration(), timeValue.getTimeUnit()) : this.connectionConfig.getConnectTimeout();
            modalCloseable = ((BasicHttpClientConnectionManager$InternalConnectionEndpoint)modalCloseable).getConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connecting endpoint to {} ({})", ConnPoolSupport.getId(object), httpHost, timeValue);
            }
            this.connectionOperator.connect((ManagedHttpClientConnection)modalCloseable, httpHost, httpRoute.getTargetName(), httpRoute.getLocalSocketAddress(), (Timeout)timeValue, this.socketConfig, httpRoute.isTunnelled() ? null : this.tlsConfig, httpContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connected {}", (Object)ConnPoolSupport.getId(object), (Object)ConnPoolSupport.getId(this.conn));
            }
            if ((object = this.connectionConfig.getSocketTimeout()) != null) {
                modalCloseable.setSocketTimeout((Timeout)object);
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void upgrade(ConnectionEndpoint connectionEndpoint, HttpContext httpContext) throws IOException {
        this.lock.lock();
        try {
            Args.notNull(connectionEndpoint, "Endpoint");
            Args.notNull(this.route, "HTTP route");
            connectionEndpoint = this.cast(connectionEndpoint);
            HttpRoute httpRoute = ((BasicHttpClientConnectionManager$InternalConnectionEndpoint)connectionEndpoint).getRoute();
            this.connectionOperator.upgrade(((BasicHttpClientConnectionManager$InternalConnectionEndpoint)connectionEndpoint).getConnection(), httpRoute.getTargetHost(), httpRoute.getTargetName(), this.tlsConfig, httpContext);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeExpired() {
        this.lock.lock();
        try {
            if (this.isClosed()) {
                return;
            }
            if (!this.leased) {
                this.checkExpiry();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeIdle(TimeValue timeValue) {
        this.lock.lock();
        try {
            Args.notNull(timeValue, "Idle time");
            if (this.isClosed()) {
                return;
            }
            if (!this.leased) {
                long l2;
                long l3 = timeValue.toMilliseconds();
                if (l3 < 0L) {
                    l3 = 0L;
                }
                if (this.updated <= (l2 = System.currentTimeMillis() - l3)) {
                    this.closeConnection(CloseMode.GRACEFUL);
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public TimeValue getValidateAfterInactivity() {
        return this.connectionConfig.getValidateAfterInactivity();
    }

    @Deprecated
    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.connectionConfig = ConnectionConfig.custom().setValidateAfterInactivity(timeValue).build();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static /* synthetic */ String access$000(BasicHttpClientConnectionManager basicHttpClientConnectionManager) {
        return basicHttpClientConnectionManager.id;
    }

    static /* synthetic */ Logger access$100() {
        return LOG;
    }
}

