/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.impl.io.LoggingSocketHolder;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.ResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultManagedHttpClientConnection
extends DefaultBHttpClientConnection
implements ManagedHttpClientConnection,
Identifiable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagedHttpClientConnection.class);
    private static final Logger HEADER_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http.headers");
    private static final Logger WIRE_LOG = LoggerFactory.getLogger("org.apache.hc.client5.http.wire");
    private final String id;
    private final AtomicBoolean closed;
    private Timeout socketTimeout;

    public DefaultManagedHttpClientConnection(String string, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, Http1Config http1Config, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, ResponseOutOfOrderStrategy responseOutOfOrderStrategy, HttpMessageWriterFactory<ClassicHttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory) {
        super(http1Config, charsetDecoder, charsetEncoder, contentLengthStrategy, contentLengthStrategy2, responseOutOfOrderStrategy, httpMessageWriterFactory, httpMessageParserFactory);
        this.id = string;
        this.closed = new AtomicBoolean();
    }

    public DefaultManagedHttpClientConnection(String string, CharsetDecoder charsetDecoder, CharsetEncoder charsetEncoder, Http1Config http1Config, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, HttpMessageWriterFactory<ClassicHttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory) {
        this(string, charsetDecoder, charsetEncoder, http1Config, contentLengthStrategy, contentLengthStrategy2, null, httpMessageWriterFactory, httpMessageParserFactory);
    }

    public DefaultManagedHttpClientConnection(String string) {
        this(string, null, null, null, null, null, null, null);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void bind(SocketHolder object) throws IOException {
        if (this.closed.get()) {
            object = ((SocketHolder)object).getSocket();
            ((Socket)object).close();
            throw new InterruptedIOException("Connection already shutdown");
        }
        super.bind((SocketHolder)object);
        this.socketTimeout = Timeout.ofMilliseconds(((SocketHolder)object).getSocket().getSoTimeout());
    }

    @Override
    public final Socket getSocket() {
        SocketHolder socketHolder = this.getSocketHolder();
        if (socketHolder != null) {
            return socketHolder.getSocket();
        }
        return null;
    }

    @Override
    public final SSLSession getSSLSession() {
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket) {
            return ((SSLSocket)socket).getSession();
        }
        return null;
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Close connection", (Object)this.id);
            }
            super.close();
        }
    }

    @Override
    public final void setSocketTimeout(Timeout timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} set socket timeout to {}", (Object)this.id, (Object)timeout);
        }
        super.setSocketTimeout(timeout);
        this.socketTimeout = timeout;
    }

    @Override
    public final void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} close connection {}", (Object)this.id, (Object)closeMode);
            }
            super.close(closeMode);
        }
    }

    @Override
    public final void bind(Socket socket) throws IOException {
        super.bind(WIRE_LOG.isDebugEnabled() ? new LoggingSocketHolder(socket, this.id, WIRE_LOG) : new SocketHolder(socket));
        this.socketTimeout = Timeout.ofMilliseconds(socket.getSoTimeout());
    }

    @Override
    public final void bind(SSLSocket sSLSocket, Socket socket) throws IOException {
        super.bind(WIRE_LOG.isDebugEnabled() ? new LoggingSocketHolder(sSLSocket, socket, this.id, WIRE_LOG) : new SocketHolder(sSLSocket, socket));
        this.socketTimeout = Timeout.ofMilliseconds(sSLSocket.getSoTimeout());
    }

    @Override
    protected final void onResponseReceived(ClassicHttpResponse headerArray) {
        if (headerArray != null && HEADER_LOG.isDebugEnabled()) {
            HEADER_LOG.debug("{} << {}", (Object)this.id, (Object)new StatusLine((HttpResponse)headerArray));
            Header[] headerArray2 = headerArray.getHeaders();
            headerArray = headerArray2;
            headerArray = headerArray2;
            int n2 = headerArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Header header = headerArray[i2];
                HEADER_LOG.debug("{} << {}", (Object)this.id, (Object)header);
            }
        }
    }

    @Override
    protected final void onRequestSubmitted(ClassicHttpRequest headerArray) {
        if (headerArray != null && HEADER_LOG.isDebugEnabled()) {
            HEADER_LOG.debug("{} >> {}", (Object)this.id, (Object)new RequestLine((HttpRequest)headerArray));
            Header[] headerArray2 = headerArray.getHeaders();
            headerArray = headerArray2;
            headerArray = headerArray2;
            int n2 = headerArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Header header = headerArray[i2];
                HEADER_LOG.debug("{} >> {}", (Object)this.id, (Object)header);
            }
        }
    }

    @Override
    public final void passivate() {
        super.setSocketTimeout(Timeout.ZERO_MILLISECONDS);
    }

    @Override
    public final void activate() {
        DefaultManagedHttpClientConnection defaultManagedHttpClientConnection = this;
        super.setSocketTimeout(defaultManagedHttpClientConnection.socketTimeout);
    }
}

