/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.impl.Wire;

class LoggingInputStream
extends FilterInputStream {
    private final Wire wire;

    LoggingInputStream(InputStream inputStream, Wire wire) {
        super(inputStream);
        this.wire = wire;
    }

    @Override
    public int read() throws IOException {
        try {
            int n2 = this.in.read();
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else {
                this.wire.input(n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        try {
            int n2 = this.in.read(byArray);
            if (n2 == -1) {
                this.wire.input("end of stream");
            } else if (n2 > 0) {
                this.wire.input(byArray, 0, n2);
            }
            return n2;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            n3 = this.in.read(byArray, n2, n3);
            if (n3 == -1) {
                this.wire.input("end of stream");
            } else if (n3 > 0) {
                this.wire.input(byArray, n2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            this.wire.input("[read] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.wire.input("[skip] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            this.wire.input("[available] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
            return;
        }
        catch (IOException iOException) {
            this.wire.input("[close] I/O error: " + iOException.getMessage());
            throw iOException;
        }
    }
}

