/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.client5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.client5.http.impl.io.DefaultManagedHttpClientConnection;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory$1;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory$Builder;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.NoResponseOutOfOrderStrategy;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.ResponseOutOfOrderStrategy;

@Contract(threading=ThreadingBehavior.STATELESS)
public class ManagedHttpClientConnectionFactory
implements HttpConnectionFactory<ManagedHttpClientConnection> {
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedHttpClientConnectionFactory INSTANCE = new ManagedHttpClientConnectionFactory();
    private final Http1Config h1Config;
    private final CharCodingConfig charCodingConfig;
    private final HttpMessageWriterFactory<ClassicHttpRequest> requestWriterFactory;
    private final HttpMessageParserFactory<ClassicHttpResponse> responseParserFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;
    private final ResponseOutOfOrderStrategy responseOutOfOrderStrategy;

    private ManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageWriterFactory<ClassicHttpRequest> defaultHttpRequestWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> defaultHttpResponseParserFactory, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, ResponseOutOfOrderStrategy responseOutOfOrderStrategy) {
        this.h1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
        this.requestWriterFactory = defaultHttpRequestWriterFactory != null ? defaultHttpRequestWriterFactory : new DefaultHttpRequestWriterFactory(this.h1Config);
        this.responseParserFactory = defaultHttpResponseParserFactory != null ? defaultHttpResponseParserFactory : new DefaultHttpResponseParserFactory(this.h1Config);
        this.incomingContentStrategy = contentLengthStrategy != null ? contentLengthStrategy : DefaultContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = contentLengthStrategy2 != null ? contentLengthStrategy2 : DefaultContentLengthStrategy.INSTANCE;
        this.responseOutOfOrderStrategy = responseOutOfOrderStrategy != null ? responseOutOfOrderStrategy : NoResponseOutOfOrderStrategy.INSTANCE;
    }

    public ManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageWriterFactory<ClassicHttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2) {
        this(http1Config, charCodingConfig, httpMessageWriterFactory, httpMessageParserFactory, contentLengthStrategy, contentLengthStrategy2, null);
    }

    public ManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageWriterFactory<ClassicHttpRequest> httpMessageWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory) {
        this(http1Config, charCodingConfig, httpMessageWriterFactory, httpMessageParserFactory, null, null);
    }

    public ManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageParserFactory<ClassicHttpResponse> httpMessageParserFactory) {
        this(http1Config, charCodingConfig, null, httpMessageParserFactory);
    }

    public ManagedHttpClientConnectionFactory() {
        this(null, null, null);
    }

    @Override
    public ManagedHttpClientConnection createConnection(Socket socket) throws IOException {
        CodingErrorAction codingErrorAction;
        Object object = null;
        CharsetEncoder charsetEncoder = null;
        Object object2 = this.charCodingConfig.getCharset();
        CodingErrorAction codingErrorAction2 = this.charCodingConfig.getMalformedInputAction() != null ? this.charCodingConfig.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction3 = codingErrorAction = this.charCodingConfig.getUnmappableInputAction() != null ? this.charCodingConfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (object2 != null) {
            object = ((Charset)object2).newDecoder();
            ((CharsetDecoder)object).onMalformedInput(codingErrorAction2);
            ((CharsetDecoder)object).onUnmappableCharacter(codingErrorAction);
            charsetEncoder = ((Charset)object2).newEncoder();
            charsetEncoder.onMalformedInput(codingErrorAction2);
            charsetEncoder.onUnmappableCharacter(codingErrorAction);
        }
        object2 = "http-outgoing-" + COUNTER.getAndIncrement();
        object = new DefaultManagedHttpClientConnection((String)object2, (CharsetDecoder)object, charsetEncoder, this.h1Config, this.incomingContentStrategy, this.outgoingContentStrategy, this.responseOutOfOrderStrategy, this.requestWriterFactory, this.responseParserFactory);
        if (socket != null) {
            ((DefaultBHttpClientConnection)object).bind(socket);
        }
        return object;
    }

    public static ManagedHttpClientConnectionFactory$Builder builder() {
        return new ManagedHttpClientConnectionFactory$Builder(null);
    }

    /* synthetic */ ManagedHttpClientConnectionFactory(Http1Config http1Config, CharCodingConfig charCodingConfig, HttpMessageWriterFactory httpMessageWriterFactory, HttpMessageParserFactory httpMessageParserFactory, ContentLengthStrategy contentLengthStrategy, ContentLengthStrategy contentLengthStrategy2, ResponseOutOfOrderStrategy responseOutOfOrderStrategy, ManagedHttpClientConnectionFactory$1 managedHttpClientConnectionFactory$1) {
        this(http1Config, charCodingConfig, httpMessageWriterFactory, httpMessageParserFactory, contentLengthStrategy, contentLengthStrategy2, responseOutOfOrderStrategy);
    }
}

