/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionHolder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.ConnectionEndpoint$RequestExecutor;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

class PoolingHttpClientConnectionManager$InternalConnectionEndpoint
extends ConnectionEndpoint
implements ConnectionHolder,
Identifiable {
    private final AtomicReference<PoolEntry<HttpRoute, ManagedHttpClientConnection>> poolEntryRef;
    private final String id;

    PoolingHttpClientConnectionManager$InternalConnectionEndpoint(PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry) {
        this.poolEntryRef = new AtomicReference<PoolEntry<HttpRoute, ManagedHttpClientConnection>>(poolEntry);
        this.id = PoolingHttpClientConnectionManager.access$500().getNextId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    PoolEntry<HttpRoute, ManagedHttpClientConnection> getPoolEntry() {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return poolEntry;
    }

    PoolEntry<HttpRoute, ManagedHttpClientConnection> getValidatedPoolEntry() {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.getPoolEntry();
        ManagedHttpClientConnection managedHttpClientConnection = poolEntry.getConnection();
        if (managedHttpClientConnection == null || !managedHttpClientConnection.isOpen()) {
            throw new ConnectionShutdownException();
        }
        return poolEntry;
    }

    PoolEntry<HttpRoute, ManagedHttpClientConnection> detach() {
        return this.poolEntryRef.getAndSet(null);
    }

    @Override
    public void close(CloseMode closeMode) {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            poolEntry.discardConnection(closeMode);
        }
    }

    @Override
    public void close() throws IOException {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
        }
    }

    @Override
    public boolean isConnected() {
        Object object = this.getPoolEntry();
        return (object = ((PoolEntry)object).getConnection()) != null && object.isOpen();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.getValidatedPoolEntry().getConnection().setSocketTimeout(timeout);
    }

    @Override
    @Deprecated
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest, HttpRequestExecutor httpRequestExecutor, HttpContext httpContext) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(httpRequestExecutor, "Request executor");
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidatedPoolEntry().getConnection();
        if (PoolingHttpClientConnectionManager.access$000().isDebugEnabled()) {
            PoolingHttpClientConnectionManager.access$000().debug("{} executing exchange {} over {}", this.id, string, ConnPoolSupport.getId(managedHttpClientConnection));
        }
        return httpRequestExecutor.execute(classicHttpRequest, managedHttpClientConnection, httpContext);
    }

    @Override
    public ClassicHttpResponse execute(String string, ClassicHttpRequest classicHttpRequest, ConnectionEndpoint$RequestExecutor connectionEndpoint$RequestExecutor, HttpContext httpContext) throws IOException, HttpException {
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(connectionEndpoint$RequestExecutor, "Request executor");
        ManagedHttpClientConnection managedHttpClientConnection = this.getValidatedPoolEntry().getConnection();
        if (PoolingHttpClientConnectionManager.access$000().isDebugEnabled()) {
            PoolingHttpClientConnectionManager.access$000().debug("{} executing exchange {} over {}", this.id, string, ConnPoolSupport.getId(managedHttpClientConnection));
        }
        return connectionEndpoint$RequestExecutor.execute(classicHttpRequest, managedHttpClientConnection, httpContext);
    }

    @Override
    public EndpointInfo getInfo() {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null && (poolEntry = poolEntry.getConnection()) != null && poolEntry.isOpen()) {
            return new EndpointInfo(poolEntry.getProtocolVersion(), poolEntry.getSSLSession());
        }
        return null;
    }

    @Override
    public HttpConnection get() {
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            return poolEntry.getConnection();
        }
        return null;
    }
}

