/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.PrefixedIncrementingId;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager$1;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager$2;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager$3;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager$InternalConnectionEndpoint;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.DefaultDisposalCallback;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class PoolingHttpClientConnectionManager
implements HttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private static final Logger LOG = LoggerFactory.getLogger(PoolingHttpClientConnectionManager.class);
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 25;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private final HttpClientConnectionOperator connectionOperator;
    private final ManagedConnPool<HttpRoute, ManagedHttpClientConnection> pool;
    private final HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    private final AtomicBoolean closed;
    private volatile Resolver<HttpRoute, SocketConfig> socketConfigResolver;
    private volatile Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver;
    private volatile Resolver<HttpHost, TlsConfig> tlsConfigResolver;
    private static final PrefixedIncrementingId INCREMENTING_ID = new PrefixedIncrementingId("ep-");

    public PoolingHttpClientConnectionManager() {
        this(new DefaultHttpClientConnectionOperator(null, null, RegistryBuilder.create().register(URIScheme.HTTPS.id, DefaultClientTlsStrategy.createDefault()).build()), PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.NEG_ONE_MILLISECOND, null);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry) {
        this(registry, null);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        this(registry, PoolConcurrencyPolicy.STRICT, TimeValue.NEG_ONE_MILLISECOND, httpConnectionFactory);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, PoolConcurrencyPolicy poolConcurrencyPolicy, TimeValue timeValue, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        this(registry, poolConcurrencyPolicy, PoolReusePolicy.LIFO, timeValue, httpConnectionFactory);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue) {
        this(registry, poolConcurrencyPolicy, poolReusePolicy, timeValue, null);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        this(registry, poolConcurrencyPolicy, poolReusePolicy, timeValue, null, null, httpConnectionFactory);
    }

    @Deprecated
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> registry, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, HttpConnectionFactory<ManagedHttpClientConnection> httpConnectionFactory) {
        this(new DefaultHttpClientConnectionOperator(registry, schemePortResolver, dnsResolver), poolConcurrencyPolicy, poolReusePolicy, timeValue, httpConnectionFactory);
    }

    @Internal
    public PoolingHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeValue, HttpConnectionFactory<ManagedHttpClientConnection> managedHttpClientConnectionFactory) {
        this.connectionOperator = Args.notNull(httpClientConnectionOperator, "Connection operator");
        switch (poolConcurrencyPolicy != null ? poolConcurrencyPolicy : PoolConcurrencyPolicy.STRICT) {
            case STRICT: {
                this.pool = new PoolingHttpClientConnectionManager$1(this, 5, 25, timeValue, poolReusePolicy, new DefaultDisposalCallback(), null);
                break;
            }
            case LAX: {
                this.pool = new PoolingHttpClientConnectionManager$2(this, 5, timeValue, poolReusePolicy, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected PoolConcurrencyPolicy value: " + (Object)((Object)poolConcurrencyPolicy));
            }
        }
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.closed = new AtomicBoolean(false);
    }

    @Internal
    protected PoolingHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, ManagedConnPool<HttpRoute, ManagedHttpClientConnection> managedConnPool, HttpConnectionFactory<ManagedHttpClientConnection> managedHttpClientConnectionFactory) {
        this.connectionOperator = Args.notNull(httpClientConnectionOperator, "Connection operator");
        this.pool = Args.notNull(managedConnPool, "Connection pool");
        this.connFactory = managedHttpClientConnectionFactory != null ? managedHttpClientConnectionFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown connection pool {}", (Object)closeMode);
            }
            this.pool.close(closeMode);
            LOG.debug("Connection pool shut down");
        }
    }

    private PoolingHttpClientConnectionManager$InternalConnectionEndpoint cast(ConnectionEndpoint connectionEndpoint) {
        if (connectionEndpoint instanceof PoolingHttpClientConnectionManager$InternalConnectionEndpoint) {
            return (PoolingHttpClientConnectionManager$InternalConnectionEndpoint)connectionEndpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + connectionEndpoint.getClass());
    }

    private SocketConfig resolveSocketConfig(HttpRoute object) {
        Resolver<HttpRoute, SocketConfig> resolver = this.socketConfigResolver;
        object = resolver != null ? resolver.resolve((HttpRoute)object) : null;
        if (object != null) {
            return object;
        }
        return SocketConfig.DEFAULT;
    }

    private ConnectionConfig resolveConnectionConfig(HttpRoute cloneable) {
        Resolver<HttpRoute, ConnectionConfig> resolver = this.connectionConfigResolver;
        cloneable = resolver != null ? resolver.resolve((HttpRoute)cloneable) : null;
        if (cloneable != null) {
            return cloneable;
        }
        return ConnectionConfig.DEFAULT;
    }

    private TlsConfig resolveTlsConfig(HttpHost object) {
        Resolver<HttpHost, TlsConfig> resolver = this.tlsConfigResolver;
        object = resolver != null ? resolver.resolve((HttpHost)object) : null;
        if (object != null) {
            return object;
        }
        return TlsConfig.DEFAULT;
    }

    private TimeValue resolveValidateAfterInactivity(ConnectionConfig object) {
        if ((object = ((ConnectionConfig)object).getValidateAfterInactivity()) != null) {
            return object;
        }
        return TimeValue.ofSeconds(2L);
    }

    public LeaseRequest lease(String string, HttpRoute httpRoute, Object object) {
        return this.lease(string, httpRoute, Timeout.DISABLED, object);
    }

    @Override
    public LeaseRequest lease(String string, HttpRoute httpRoute, Timeout object, Object object2) {
        Args.notNull(httpRoute, "HTTP route");
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} endpoint lease request ({}) {}", string, object, ConnPoolSupport.formatStats(httpRoute, object2, this.pool));
        }
        object = this.pool.lease(httpRoute, object2, (Timeout)object, null);
        return new PoolingHttpClientConnectionManager$3(this, (Future)object, string, httpRoute, object2);
    }

    @Override
    public void release(ConnectionEndpoint connectionEndpoint, Object object, TimeValue timeValue) {
        boolean bl2;
        PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry;
        block13: {
            Args.notNull(connectionEndpoint, "Managed endpoint");
            poolEntry = this.cast(connectionEndpoint).detach();
            if (poolEntry == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} releasing endpoint", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
            if (this.isClosed()) {
                return;
            }
            ManagedHttpClientConnection managedHttpClientConnection = poolEntry.getConnection();
            if (managedHttpClientConnection != null && timeValue == null) {
                managedHttpClientConnection.close(CloseMode.GRACEFUL);
            }
            bl2 = managedHttpClientConnection != null && managedHttpClientConnection.isOpen() && managedHttpClientConnection.isConsistent();
            try {
                if (bl2) {
                    poolEntry.updateState(object);
                    poolEntry.updateExpiry(timeValue);
                    managedHttpClientConnection.passivate();
                    if (LOG.isDebugEnabled()) {
                        object = TimeValue.isPositive(timeValue) ? "for " + timeValue : "indefinitely";
                        LOG.debug("{} connection {} can be kept alive {}", ConnPoolSupport.getId(connectionEndpoint), ConnPoolSupport.getId(managedHttpClientConnection), object);
                    }
                    break block13;
                }
                if (!LOG.isDebugEnabled()) break block13;
                if (managedHttpClientConnection != null && !managedHttpClientConnection.isConsistent()) {
                    LOG.debug("{} connection is in an inconsistent state and cannot be kept alive", (Object)ConnPoolSupport.getId(connectionEndpoint));
                    break block13;
                }
                LOG.debug("{} connection is not kept alive", (Object)ConnPoolSupport.getId(connectionEndpoint));
            }
            catch (RuntimeException runtimeException) {
                try {
                    bl2 = false;
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    this.pool.release(poolEntry, bl2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connection released {}", (Object)ConnPoolSupport.getId(connectionEndpoint), (Object)ConnPoolSupport.formatStats(poolEntry.getRoute(), poolEntry.getState(), this.pool));
                    }
                    throw throwable;
                }
            }
        }
        this.pool.release(poolEntry, bl2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connection released {}", (Object)ConnPoolSupport.getId(connectionEndpoint), (Object)ConnPoolSupport.formatStats(poolEntry.getRoute(), poolEntry.getState(), this.pool));
            return;
        }
    }

    @Override
    public void connect(ConnectionEndpoint object, TimeValue timeValue, HttpContext httpContext) throws IOException {
        HttpRoute httpRoute;
        Args.notNull(object, "Managed endpoint");
        Object object2 = this.cast((ConnectionEndpoint)object);
        if (((ConnectionEndpoint)object2).isConnected()) {
            return;
        }
        if (!((PoolEntry)(object2 = ((PoolingHttpClientConnectionManager$InternalConnectionEndpoint)object2).getPoolEntry())).hasConnection()) {
            ((PoolEntry)object2).assignConnection(this.connFactory.createConnection(null));
        }
        HttpHost httpHost = (httpRoute = (HttpRoute)((PoolEntry)object2).getRoute()).getProxyHost() != null ? httpRoute.getProxyHost() : httpRoute.getTargetHost();
        SocketConfig socketConfig = this.resolveSocketConfig(httpRoute);
        ConnectionConfig connectionConfig = this.resolveConnectionConfig(httpRoute);
        TimeValue timeValue2 = timeValue = timeValue != null ? Timeout.of(timeValue.getDuration(), timeValue.getTimeUnit()) : connectionConfig.getConnectTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting endpoint to {} ({})", ConnPoolSupport.getId(object), httpHost, timeValue);
        }
        object2 = (ManagedHttpClientConnection)((PoolEntry)object2).getConnection();
        this.connectionOperator.connect((ManagedHttpClientConnection)object2, httpHost, httpRoute.getTargetName(), httpRoute.getLocalSocketAddress(), (Timeout)timeValue, socketConfig, httpRoute.isTunnelled() ? null : this.resolveTlsConfig(httpRoute.getTargetHost()), httpContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connected {}", (Object)ConnPoolSupport.getId(object), (Object)ConnPoolSupport.getId(object2));
        }
        if ((object = connectionConfig.getSocketTimeout()) != null) {
            object2.setSocketTimeout((Timeout)object);
        }
    }

    @Override
    public void upgrade(ConnectionEndpoint object, HttpContext httpContext) throws IOException {
        Args.notNull(object, "Managed endpoint");
        object = this.cast((ConnectionEndpoint)object);
        object = ((PoolingHttpClientConnectionManager$InternalConnectionEndpoint)object).getValidatedPoolEntry();
        HttpRoute httpRoute = ((PoolEntry)object).getRoute();
        HttpHost httpHost = httpRoute.getTargetHost();
        TlsConfig tlsConfig = this.resolveTlsConfig(httpHost);
        this.connectionOperator.upgrade((ManagedHttpClientConnection)((PoolEntry)object).getConnection(), httpHost, httpRoute.getTargetName(), tlsConfig, httpContext);
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        Args.notNull(timeValue, "Idle time");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing connections idle longer than {}", (Object)timeValue);
        }
        if (this.isClosed()) {
            return;
        }
        this.pool.closeIdle(timeValue);
    }

    @Override
    public void closeExpired() {
        if (this.isClosed()) {
            return;
        }
        LOG.debug("Closing expired connections");
        this.pool.closeExpired();
    }

    @Override
    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setMaxTotal(int n2) {
        this.pool.setMaxTotal(n2);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        this.pool.setDefaultMaxPerRoute(n2);
    }

    @Override
    public int getMaxPerRoute(HttpRoute httpRoute) {
        return this.pool.getMaxPerRoute(httpRoute);
    }

    @Override
    public void setMaxPerRoute(HttpRoute httpRoute, int n2) {
        this.pool.setMaxPerRoute(httpRoute, n2);
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute httpRoute) {
        return this.pool.getStats(httpRoute);
    }

    public void setDefaultSocketConfig(SocketConfig socketConfig) {
        this.socketConfigResolver = httpRoute -> socketConfig;
    }

    public void setSocketConfigResolver(Resolver<HttpRoute, SocketConfig> resolver) {
        this.socketConfigResolver = resolver;
    }

    public void setDefaultConnectionConfig(ConnectionConfig connectionConfig) {
        this.connectionConfigResolver = httpRoute -> connectionConfig;
    }

    public void setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> resolver) {
        this.connectionConfigResolver = resolver;
    }

    public void setDefaultTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfigResolver = httpHost -> tlsConfig;
    }

    public void setTlsConfigResolver(Resolver<HttpHost, TlsConfig> resolver) {
        this.tlsConfigResolver = resolver;
    }

    void closeIfExpired(PoolEntry<HttpRoute, ManagedHttpClientConnection> poolEntry) {
        long l2 = System.currentTimeMillis();
        if (poolEntry.getExpiryDeadline().isBefore(l2)) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
            return;
        }
        Object object = this.resolveConnectionConfig(poolEntry.getRoute());
        if ((object = ((ConnectionConfig)object).getTimeToLive()) != null && Deadline.calculate(poolEntry.getCreated(), (TimeValue)object).isBefore(l2)) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
        }
    }

    @Deprecated
    public SocketConfig getDefaultSocketConfig() {
        return SocketConfig.DEFAULT;
    }

    @Deprecated
    public TimeValue getValidateAfterInactivity() {
        return ConnectionConfig.DEFAULT.getValidateAfterInactivity();
    }

    @Deprecated
    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(timeValue).build());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ ManagedConnPool access$100(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        return poolingHttpClientConnectionManager.pool;
    }

    static /* synthetic */ ConnectionConfig access$200(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager, HttpRoute httpRoute) {
        return poolingHttpClientConnectionManager.resolveConnectionConfig(httpRoute);
    }

    static /* synthetic */ TimeValue access$300(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager, ConnectionConfig connectionConfig) {
        return poolingHttpClientConnectionManager.resolveValidateAfterInactivity(connectionConfig);
    }

    static /* synthetic */ HttpConnectionFactory access$400(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        return poolingHttpClientConnectionManager.connFactory;
    }

    static /* synthetic */ PrefixedIncrementingId access$500() {
        return INCREMENTING_ID;
    }
}

