/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator$1;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator$2;
import org.apache.hc.client5.http.impl.nio.MultihomeIOSessionRequester;
import org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultAsyncClientConnectionOperator
implements AsyncClientConnectionOperator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAsyncClientConnectionOperator.class);
    private final SchemePortResolver schemePortResolver;
    private final MultihomeIOSessionRequester sessionRequester;
    private final Lookup<TlsStrategy> tlsStrategyLookup;

    protected DefaultAsyncClientConnectionOperator(Lookup<TlsStrategy> lookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this.tlsStrategyLookup = Args.notNull(lookup, "TLS strategy lookup");
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.sessionRequester = new MultihomeIOSessionRequester(dnsResolver);
    }

    @Override
    public Future<ManagedAsyncClientConnection> connect(ConnectionInitiator connectionInitiator, HttpHost httpHost, SocketAddress socketAddress, Timeout timeout, Object object, FutureCallback<ManagedAsyncClientConnection> futureCallback) {
        return this.connect(connectionInitiator, httpHost, null, socketAddress, timeout, object, null, futureCallback);
    }

    @Override
    public Future<ManagedAsyncClientConnection> connect(ConnectionInitiator object, HttpHost httpHost, NamedEndpoint namedEndpoint, SocketAddress socketAddress, Timeout timeout, Object object2, HttpContext httpContext, FutureCallback<ManagedAsyncClientConnection> object3) {
        Args.notNull(object, "Connection initiator");
        Args.notNull(httpHost, "Host");
        object3 = new ComplexFuture<ManagedAsyncClientConnection>((FutureCallback<ManagedAsyncClientConnection>)object3);
        HttpHost httpHost2 = RoutingSupport.normalize(httpHost, this.schemePortResolver);
        InetAddress inetAddress = httpHost.getAddress();
        TlsConfig tlsConfig = object2 instanceof TlsConfig ? (TlsConfig)object2 : TlsConfig.DEFAULT;
        this.onBeforeSocketConnect(httpContext, httpHost);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting {}->{} ({})", httpHost, socketAddress, inetAddress, timeout);
        }
        object = this.sessionRequester.connect((ConnectionInitiator)object, httpHost2, inetAddress != null ? new InetSocketAddress(inetAddress, httpHost2.getPort()) : null, socketAddress, timeout, (Object)tlsConfig.getHttpVersionPolicy(), new DefaultAsyncClientConnectionOperator$1(this, httpContext, httpHost, tlsConfig, timeout, namedEndpoint, object2, (ComplexFuture)object3));
        ((ComplexFuture)object3).setDependency((Future<?>)object);
        return object3;
    }

    @Override
    public void upgrade(ManagedAsyncClientConnection managedAsyncClientConnection, HttpHost httpHost, Object object) {
        this.upgrade(managedAsyncClientConnection, httpHost, null, object, null, null);
    }

    @Override
    public void upgrade(ManagedAsyncClientConnection managedAsyncClientConnection, HttpHost namedEndpoint, NamedEndpoint namedEndpoint2, Object object, HttpContext object2, FutureCallback<ManagedAsyncClientConnection> futureCallback) {
        object2 = URIScheme.HTTP.same(namedEndpoint.getSchemeName()) ? URIScheme.HTTPS.id : namedEndpoint.getSchemeName();
        TlsStrategy tlsStrategy = this.tlsStrategyLookup != null ? this.tlsStrategyLookup.lookup((String)object2) : null;
        if (tlsStrategy != null) {
            NamedEndpoint namedEndpoint3 = namedEndpoint = namedEndpoint2 != null ? namedEndpoint2 : namedEndpoint;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {} upgrading to TLS", (Object)ConnPoolSupport.getId(managedAsyncClientConnection), (Object)namedEndpoint);
            }
            FutureCallback<ManagedAsyncClientConnection> futureCallback2 = futureCallback;
            tlsStrategy.upgrade(managedAsyncClientConnection, namedEndpoint, object, null, new DefaultAsyncClientConnectionOperator$2(this, futureCallback2, futureCallback2, managedAsyncClientConnection));
            return;
        }
        futureCallback.failed(new UnsupportedSchemeException((String)object2 + " protocol is not supported"));
    }

    protected void onBeforeSocketConnect(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onAfterSocketConnect(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onBeforeTlsHandshake(HttpContext httpContext, HttpHost httpHost) {
    }

    protected void onAfterTlsHandshake(HttpContext httpContext, HttpHost httpHost) {
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ Lookup access$100(DefaultAsyncClientConnectionOperator defaultAsyncClientConnectionOperator) {
        return defaultAsyncClientConnectionOperator.tlsStrategyLookup;
    }
}

