/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.impl.nio.MultihomeIOSessionRequester$1;
import org.apache.hc.client5.http.impl.nio.MultihomeIOSessionRequester$2;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MultihomeIOSessionRequester {
    private static final Logger LOG = LoggerFactory.getLogger(MultihomeIOSessionRequester.class);
    private final DnsResolver dnsResolver;

    MultihomeIOSessionRequester(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    public final Future<IOSession> connect(ConnectionInitiator object, NamedEndpoint namedEndpoint, SocketAddress future, SocketAddress socketAddress, Timeout timeout, Object object2, FutureCallback<IOSession> object3) {
        object3 = new ComplexFuture<IOSession>((FutureCallback<IOSession>)object3);
        if (future != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}:{} connecting {} to {} ({})", namedEndpoint.getHostName(), namedEndpoint.getPort(), socketAddress, future, timeout);
            }
            future = object.connect(namedEndpoint, (SocketAddress)((Object)future), socketAddress, timeout, object2, new MultihomeIOSessionRequester$1(this, (ComplexFuture)object3, namedEndpoint, (SocketAddress)((Object)future)));
            ((ComplexFuture)object3).setDependency(future);
            return object3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} resolving remote address", (Object)namedEndpoint.getHostName());
        }
        try {
            future = this.dnsResolver.resolve(namedEndpoint.getHostName(), namedEndpoint.getPort());
            if (future == null || future.isEmpty()) {
                throw new UnknownHostException(namedEndpoint.getHostName());
            }
        }
        catch (UnknownHostException unknownHostException) {
            ((BasicFuture)object3).failed(unknownHostException);
            return object3;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} resolved to {}", (Object)namedEndpoint.getHostName(), (Object)future);
        }
        object = new MultihomeIOSessionRequester$2(this, (List)((Object)future), namedEndpoint, socketAddress, timeout, (ConnectionInitiator)object, object2, (ComplexFuture)object3);
        object.run();
        return object3;
    }

    public final Future<IOSession> connect(ConnectionInitiator connectionInitiator, NamedEndpoint namedEndpoint, SocketAddress socketAddress, Timeout timeout, Object object, FutureCallback<IOSession> futureCallback) {
        return this.connect(connectionInitiator, namedEndpoint, null, socketAddress, timeout, object, futureCallback);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

