/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$3;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager$InternalConnectionEndpoint;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.TimeValue;

class PoolingAsyncClientConnectionManager$3$1
implements FutureCallback<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> {
    final /* synthetic */ PoolingAsyncClientConnectionManager$3 this$1;

    PoolingAsyncClientConnectionManager$3$1(PoolingAsyncClientConnectionManager$3 var1_1) {
        this.this$1 = var1_1;
    }

    @Override
    public void completed(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
        Object object;
        if (poolEntry.hasConnection() && TimeValue.isNonNegative((TimeValue)(object = this.this$1.connectionConfig.getTimeToLive())) && (((TimeValue)object).getDuration() == 0L || Deadline.calculate(poolEntry.getCreated(), (TimeValue)object).isExpired())) {
            poolEntry.discardConnection(CloseMode.GRACEFUL);
        }
        if (poolEntry.hasConnection()) {
            object = poolEntry.getConnection();
            Object object2 = this.this$1.connectionConfig.getValidateAfterInactivity();
            if (object.isOpen() && TimeValue.isNonNegative((TimeValue)object2) && (((TimeValue)object2).getDuration() == 0L || Deadline.calculate(poolEntry.getUpdated(), (TimeValue)object2).isExpired()) && (object2 = object.getProtocolVersion()) != null && ((ProtocolVersion)object2).greaterEquals(HttpVersion.HTTP_2_0)) {
                PoolingAsyncClientConnectionManager$3$1 poolingAsyncClientConnectionManager$3$1 = this;
                object.submitCommand(new PingCommand(new BasicPingHandler(arg_0 -> poolingAsyncClientConnectionManager$3$1.lambda$completed$0(poolingAsyncClientConnectionManager$3$1.this$1.val$id, (ManagedAsyncClientConnection)object, poolEntry, arg_0))), Command$Priority.IMMEDIATE);
                return;
            }
        }
        this.leaseCompleted(poolEntry);
    }

    void leaseCompleted(PoolEntry<HttpRoute, ManagedAsyncClientConnection> object) {
        ManagedAsyncClientConnection managedAsyncClientConnection = ((PoolEntry)object).getConnection();
        if (managedAsyncClientConnection != null) {
            managedAsyncClientConnection.activate();
            if (this.this$1.connectionConfig.getSocketTimeout() != null) {
                managedAsyncClientConnection.setSocketTimeout(this.this$1.connectionConfig.getSocketTimeout());
            }
        }
        if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
            PoolingAsyncClientConnectionManager.access$100().debug("{} endpoint leased {}", (Object)this.this$1.val$id, (Object)ConnPoolSupport.formatStats(this.this$1.val$route, this.this$1.val$state, PoolingAsyncClientConnectionManager.access$200(this.this$1.this$0)));
        }
        object = new PoolingAsyncClientConnectionManager$InternalConnectionEndpoint((PoolEntry<HttpRoute, ManagedAsyncClientConnection>)object);
        if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
            PoolingAsyncClientConnectionManager.access$100().debug("{} acquired {}", (Object)this.this$1.val$id, (Object)ConnPoolSupport.getId(object));
        }
        this.this$1.resultFuture.completed((AsyncConnectionEndpoint)object);
    }

    @Override
    public void failed(Exception exception) {
        if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
            PoolingAsyncClientConnectionManager.access$100().debug("{} endpoint lease failed", (Object)this.this$1.val$id);
        }
        this.this$1.resultFuture.failed(exception);
    }

    @Override
    public void cancelled() {
        if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
            PoolingAsyncClientConnectionManager.access$100().debug("{} endpoint lease cancelled", (Object)this.this$1.val$id);
        }
        this.this$1.resultFuture.cancel();
    }

    private /* synthetic */ void lambda$completed$0(String string, ManagedAsyncClientConnection managedAsyncClientConnection, PoolEntry poolEntry, Boolean bl2) {
        if (bl2 == null || !bl2.booleanValue()) {
            if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.access$100().debug("{} connection {} is stale", (Object)string, (Object)ConnPoolSupport.getId(managedAsyncClientConnection));
            }
            poolEntry.discardConnection(CloseMode.GRACEFUL);
        }
        this.leaseCompleted(poolEntry);
    }
}

