/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionHolder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

class PoolingAsyncClientConnectionManager$InternalConnectionEndpoint
extends AsyncConnectionEndpoint
implements ConnectionHolder,
Identifiable {
    private final AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> poolEntryRef;
    private final String id;

    PoolingAsyncClientConnectionManager$InternalConnectionEndpoint(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
        this.poolEntryRef = new AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(poolEntry);
        this.id = PoolingAsyncClientConnectionManager.access$300().getNextId();
    }

    @Override
    public String getId() {
        return this.id;
    }

    PoolEntry<HttpRoute, ManagedAsyncClientConnection> getPoolEntry() {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry == null) {
            throw new ConnectionShutdownException();
        }
        return poolEntry;
    }

    PoolEntry<HttpRoute, ManagedAsyncClientConnection> getValidatedPoolEntry() {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.getPoolEntry();
        if (poolEntry.getConnection() == null) {
            throw new ConnectionShutdownException();
        }
        return poolEntry;
    }

    PoolEntry<HttpRoute, ManagedAsyncClientConnection> detach() {
        return this.poolEntryRef.getAndSet(null);
    }

    @Override
    public void close(CloseMode closeMode) {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
                PoolingAsyncClientConnectionManager.access$100().debug("{} close {}", (Object)this.id, (Object)closeMode);
            }
            poolEntry.discardConnection(closeMode);
        }
    }

    @Override
    public boolean isConnected() {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry == null) {
            return false;
        }
        ManagedAsyncClientConnection managedAsyncClientConnection = poolEntry.getConnection();
        if (managedAsyncClientConnection == null) {
            return false;
        }
        if (!managedAsyncClientConnection.isOpen()) {
            poolEntry.discardConnection(CloseMode.IMMEDIATE);
            return false;
        }
        return true;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.getValidatedPoolEntry().getConnection().setSocketTimeout(timeout);
    }

    @Override
    public void execute(String string, AsyncClientExchangeHandler asyncClientExchangeHandler, HandlerFactory<AsyncPushConsumer> handlerFactory, HttpContext httpContext) {
        ManagedAsyncClientConnection managedAsyncClientConnection = this.getValidatedPoolEntry().getConnection();
        if (PoolingAsyncClientConnectionManager.access$100().isDebugEnabled()) {
            PoolingAsyncClientConnectionManager.access$100().debug("{} executing exchange {} over {}", this.id, string, ConnPoolSupport.getId(managedAsyncClientConnection));
        }
        httpContext.setProtocolVersion(managedAsyncClientConnection.getProtocolVersion());
        managedAsyncClientConnection.submitCommand(new RequestExecutionCommand(asyncClientExchangeHandler, handlerFactory, httpContext), Command$Priority.NORMAL);
    }

    @Override
    public EndpointInfo getInfo() {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null && (poolEntry = poolEntry.getConnection()) != null && poolEntry.isOpen()) {
            TlsDetails tlsDetails = poolEntry.getTlsDetails();
            return new EndpointInfo(poolEntry.getProtocolVersion(), tlsDetails != null ? tlsDetails.getSSLSession() : null);
        }
        return null;
    }

    @Override
    public HttpConnection get() {
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
        if (poolEntry != null) {
            return poolEntry.getConnection();
        }
        return null;
    }
}

