/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    private static boolean sameNamedEndpoint(NamedEndpoint namedEndpoint, NamedEndpoint namedEndpoint2) {
        if (namedEndpoint == null || namedEndpoint2 == null) {
            return false;
        }
        return Objects.equals(namedEndpoint.getHostName(), namedEndpoint2.getHostName()) && namedEndpoint.getPort() == namedEndpoint2.getPort();
    }

    @Override
    public final HttpRoute determineRoute(HttpHost serializable, HttpRequest object, HttpContext httpContext) throws HttpException {
        HttpHost httpHost;
        if (serializable == null) {
            throw new ProtocolException("Target host is not specified");
        }
        Object object2 = HttpClientContext.cast(httpContext);
        object2 = ((HttpClientContext)object2).getRequestConfigOrDefault();
        if ((object2 = ((RequestConfig)object2).getProxy()) == null) {
            object2 = this.determineProxy((HttpHost)serializable, httpContext);
        }
        if ((httpHost = RoutingSupport.normalize(serializable, this.schemePortResolver)).getPort() < 0) {
            throw new ProtocolException("Unroutable protocol scheme: " + httpHost);
        }
        boolean bl2 = URIScheme.HTTPS.same(httpHost.getSchemeName());
        serializable = bl2 && object != null && !DefaultRoutePlanner.sameNamedEndpoint(object.getAuthority(), serializable) ? object.getAuthority() : null;
        object = this.determineLocalAddress(httpHost, httpContext);
        if (object2 == null) {
            return new HttpRoute(httpHost, (NamedEndpoint)((Object)serializable), (InetAddress)object, bl2);
        }
        return new HttpRoute(httpHost, (NamedEndpoint)((Object)serializable), (InetAddress)object, (HttpHost)object2, bl2);
    }

    @Override
    public final HttpRoute determineRoute(HttpHost httpHost, HttpContext httpContext) throws HttpException {
        return this.determineRoute(httpHost, null, httpContext);
    }

    protected HttpHost determineProxy(HttpHost httpHost, HttpContext httpContext) throws HttpException {
        return null;
    }

    protected InetAddress determineLocalAddress(HttpHost httpHost, HttpContext httpContext) throws HttpException {
        return null;
    }
}

