/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public class DistributedProxySelector
extends ProxySelector {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedProxySelector.class);
    private final List<ProxySelector> selectors;
    private final ThreadLocal<ProxySelector> currentSelector;
    private final AtomicInteger sharedIndex;

    public DistributedProxySelector(List<ProxySelector> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("At least one ProxySelector is required");
        }
        this.selectors = new ArrayList<ProxySelector>(list);
        this.currentSelector = new ThreadLocal();
        this.sharedIndex = new AtomicInteger();
    }

    @Override
    public List<Proxy> select(URI uRI) {
        List<Proxy> list = Collections.emptyList();
        for (int i2 = 0; i2 < this.selectors.size(); ++i2) {
            ProxySelector proxySelector = this.nextSelector();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting next proxy selector for URI {}: {}", (Object)uRI, (Object)proxySelector);
            }
            try {
                this.currentSelector.set(proxySelector);
                list = this.currentSelector.get().select(uRI);
                if (list.isEmpty()) continue;
                break;
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Exception caught while selecting proxy for URI {}: {}", (Object)uRI, (Object)exception.getMessage());
                continue;
            }
            finally {
                this.currentSelector.remove();
            }
        }
        return list;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        ProxySelector proxySelector = this.currentSelector.get();
        if (proxySelector != null) {
            proxySelector.connectFailed(uRI, socketAddress, iOException);
            this.currentSelector.remove();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed the current ProxySelector for URI {}: {}", (Object)uRI, (Object)proxySelector);
            }
        }
    }

    private ProxySelector nextSelector() {
        int n3 = this.sharedIndex.getAndUpdate(n2 -> (n2 + 1) % this.selectors.size());
        return this.selectors.get(n3);
    }
}

