/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.FormattedHeader;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.STATELESS)
public class NextNonceInterceptor
implements HttpResponseInterceptor {
    public static final HttpResponseInterceptor INSTANCE = new NextNonceInterceptor();
    private final Tokenizer tokenParser = Tokenizer.INSTANCE;
    private static final String AUTHENTICATION_INFO_HEADER = "Authentication-Info";
    private static final Tokenizer$Delimiter TOKEN_DELIMS = Tokenizer.delimiters('=', ',');
    private static final Tokenizer$Delimiter VALUE_DELIMS = Tokenizer.delimiters(',');

    @Override
    public void process(HttpResponse object, EntityDetails object2, HttpContext httpContext) {
        Args.notNull(object, "HTTP response");
        Args.notNull(httpContext, "HTTP context");
        object = object.getFirstHeader(AUTHENTICATION_INFO_HEADER);
        if (object != null) {
            if (object instanceof FormattedHeader) {
                object2 = ((FormattedHeader)object).getBuffer();
                object = new ParserCursor(((FormattedHeader)object).getValuePos(), object2.length());
                object = this.parseNextNonce((CharSequence)object2, (ParserCursor)object);
            } else {
                object2 = object.getValue();
                object = new ParserCursor(0, object2.length());
                object = this.parseNextNonce((CharSequence)object2, (ParserCursor)object);
            }
            if (!TextUtils.isBlank((CharSequence)object)) {
                HttpClientContext.castOrCreate(httpContext).setNextNonce((String)object);
            }
        }
    }

    private String parseNextNonce(CharSequence charSequence, ParserCursor parserCursor) {
        while (!parserCursor.atEnd()) {
            String string = this.tokenParser.parseToken(charSequence, (Tokenizer$Cursor)parserCursor, TOKEN_DELIMS);
            if ("nextnonce".equals(string)) {
                ParserCursor parserCursor2 = parserCursor;
                parserCursor2.updatePos(parserCursor2.getPos() + 1);
                return this.tokenParser.parseValue(charSequence, (Tokenizer$Cursor)parserCursor, VALUE_DELIMS);
            }
            if (parserCursor.atEnd()) continue;
            ParserCursor parserCursor3 = parserCursor;
            parserCursor3.updatePos(parserCursor3.getPos() + 1);
        }
        return null;
    }
}

