/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest httpRequest, EntityDetails object, HttpContext object2) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        object = httpRequest.getMethod();
        if (Method.CONNECT.isSame((String)object)) {
            return;
        }
        object = HttpClientContext.cast((HttpContext)object2);
        object2 = ((HttpClientContext)object).getExchangeId();
        if ((object = ((HttpClientContext)object).getHttpRoute()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", object2);
            }
            return;
        }
        if ((object.getHopCount() == 1 || object.isTunnelled()) && !httpRequest.containsHeader("Connection")) {
            httpRequest.addHeader("Connection", "keep-alive");
        }
    }
}

