/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import java.time.Instant;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.client5.http.validator.ValidatorType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestIfRange
implements HttpRequestInterceptor {
    public static final RequestIfRange INSTANCE = new RequestIfRange();

    @Override
    public void process(HttpRequest object, EntityDetails object2, HttpContext object3) throws HttpException, IOException {
        Args.notNull(object, "HTTP request");
        object2 = object.getFirstHeader("If-Range");
        if (object2 == null) {
            return;
        }
        if (!object.containsHeader("Range")) {
            throw new ProtocolException("Request with 'If-Range' header must also contain a 'Range' header.");
        }
        object2 = ETag.get((MessageHeaders)object);
        if (object2 != null && ((ETag)object2).getType() == ValidatorType.WEAK) {
            throw new ProtocolException("'If-Range' header must not contain a weak entity tag.");
        }
        object3 = DateUtils.parseStandardDate((MessageHeaders)object, "Date");
        if (object3 == null) {
            return;
        }
        if ((object = DateUtils.parseStandardDate((MessageHeaders)object, "Last-Modified")) == null) {
            return;
        }
        if (((Instant)object).plusSeconds(1L).isAfter((Instant)object3) && object2 != null) {
            throw new ProtocolException("'If-Range' header with a Date must be a strong validator.");
        }
    }
}

