/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class RequestUpgrade
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUpgrade.class);

    @Override
    public final void process(HttpRequest httpRequest, EntityDetails object, HttpContext object2) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(object2, "HTTP context");
        object = HttpClientContext.cast((HttpContext)object2);
        object2 = ((HttpClientContext)object).getRequestConfigOrDefault();
        if (((RequestConfig)object2).isProtocolUpgradeEnabled()) {
            Object object3 = object2 = httpRequest.getVersion() != null ? httpRequest.getVersion() : ((HttpCoreContext)object).getProtocolVersion();
            if (!httpRequest.containsHeader("Upgrade") && !httpRequest.containsHeader("Connection") && ((ProtocolVersion)object2).getMajor() == 1 && ((ProtocolVersion)object2).getMinor() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection is upgradable: protocol version = {}", object2);
                }
                if ((Method.OPTIONS.isSame((String)(object2 = httpRequest.getMethod())) || Method.HEAD.isSame((String)object2) || Method.GET.isSame((String)object2)) && ((HttpCoreContext)object).getSSLSession() == null) {
                    LOG.debug("Connection is upgradable to TLS: method = {}", object2);
                    httpRequest.addHeader("Upgrade", "TLS/1.2");
                    httpRequest.addHeader("Connection", "Upgrade");
                }
            }
        }
    }
}

