/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestValidateTrace
implements HttpRequestInterceptor {
    public static final HttpRequestInterceptor INSTANCE = new RequestValidateTrace();

    @Override
    public void process(HttpRequest object, EntityDetails object2, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(object, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        if (Method.TRACE.isSame(object.getMethod())) {
            if (object2 != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a request body.");
            }
            object2 = object.getHeader("Authorization");
            if (object2 != null) {
                throw new ProtocolException("TRACE request MUST NOT contain an Authorization header.");
            }
            if ((object = object.getHeader("Cookie")) != null) {
                throw new ProtocolException("TRACE request MUST NOT contain a Cookie header.");
            }
        }
    }
}

