/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public final class PublicSuffixMatcherLoader {
    private static final String PUBLIC_SUFFIX_LIST = "/org/publicsuffix/list/effective_tld_names.dat";
    private static final Logger LOG = LoggerFactory.getLogger(PublicSuffixMatcherLoader.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static volatile PublicSuffixMatcher DEFAULT_INSTANCE;

    private static PublicSuffixMatcher load(InputStream object) throws IOException {
        object = PublicSuffixListParser.INSTANCE.parseByType(new InputStreamReader((InputStream)object, StandardCharsets.UTF_8));
        return new PublicSuffixMatcher((Collection<PublicSuffixList>)object);
    }

    public static PublicSuffixMatcher load(URL object) throws IOException {
        PublicSuffixMatcher publicSuffixMatcher;
        block9: {
            Args.notNull(object, "URL");
            object = ((URL)object).openStream();
            Throwable throwable = null;
            try {
                publicSuffixMatcher = PublicSuffixMatcherLoader.load((InputStream)object);
                if (object == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)object).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)object).close();
                        }
                    }
                    throw throwable4;
                }
            }
            ((InputStream)object).close();
        }
        return publicSuffixMatcher;
    }

    public static PublicSuffixMatcher load(File object) throws IOException {
        PublicSuffixMatcher publicSuffixMatcher;
        Args.notNull(object, "File");
        object = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            publicSuffixMatcher = PublicSuffixMatcherLoader.load((InputStream)object);
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    ((InputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)object).close();
        return publicSuffixMatcher;
    }

    public static PublicSuffixMatcher getDefault() {
        if (DEFAULT_INSTANCE == null) {
            lock.lock();
            try {
                if (DEFAULT_INSTANCE == null) {
                    URL uRL = PublicSuffixMatcherLoader.class.getResource(PUBLIC_SUFFIX_LIST);
                    if (uRL != null) {
                        try {
                            DEFAULT_INSTANCE = PublicSuffixMatcherLoader.load(uRL);
                        }
                        catch (IOException iOException) {
                            LOG.warn("Failure loading public suffix list from default resource", iOException);
                        }
                    } else {
                        DEFAULT_INSTANCE = new PublicSuffixMatcher(DomainType.ICANN, Collections.singletonList("com"), null);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return DEFAULT_INSTANCE;
    }
}

