/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.routing;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.net.NamedEndpoint;

public final class RoutingSupport {
    public static HttpHost determineHost(HttpRequest object) throws HttpException {
        if (object == null) {
            return null;
        }
        Serializable serializable = object.getAuthority();
        if (serializable != null) {
            if ((object = object.getScheme()) == null) {
                throw new ProtocolException("Protocol scheme is not specified");
            }
            return new HttpHost((String)object, (NamedEndpoint)((Object)serializable));
        }
        try {
            object = object.getUri();
            if (((URI)object).isAbsolute()) {
                serializable = URIUtils.extractHost((URI)object);
                if (serializable == null) {
                    throw new ProtocolException("URI does not specify a valid host name: " + object);
                }
                return serializable;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    public static HttpHost normalize(HttpHost httpHost, SchemePortResolver schemePortResolver) {
        int n2;
        if (httpHost == null) {
            return null;
        }
        if (httpHost.getPort() < 0 && (n2 = (schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE).resolve(httpHost)) > 0) {
            return new HttpHost(httpHost.getSchemeName(), httpHost.getAddress(), httpHost.getHostName(), n2);
        }
        return httpHost;
    }
}

