/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.ssl.AbstractClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContexts;
import org.conscrypt.Conscrypt;

@Contract(threading=ThreadingBehavior.STATELESS)
public class ConscryptClientTlsStrategy
extends AbstractClientTlsStrategy {
    public static TlsStrategy getDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createDefault(), HostnameVerificationPolicy.BOTH, HttpsSupport.getDefaultHostnameVerifier());
    }

    public static TlsStrategy getSystemDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createSystemDefault(), HttpsSupport.getSystemProtocols(), HttpsSupport.getSystemCipherSuits(), SSLBufferMode.STATIC, HostnameVerificationPolicy.BOTH, HttpsSupport.getDefaultHostnameVerifier());
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, String[] stringArray, String[] stringArray2, SSLBufferMode sSLBufferMode, HostnameVerifier hostnameVerifier) {
        this(sSLContext, stringArray, stringArray2, sSLBufferMode, HostnameVerificationPolicy.CLIENT, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, String[] stringArray, String[] stringArray2, SSLBufferMode sSLBufferMode, HostnameVerificationPolicy hostnameVerificationPolicy, HostnameVerifier hostnameVerifier) {
        super(sSLContext, stringArray, stringArray2, sSLBufferMode, hostnameVerificationPolicy, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, HostnameVerifier hostnameVerifier) {
        this(sSLContext, null, null, SSLBufferMode.STATIC, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext, HostnameVerificationPolicy hostnameVerificationPolicy, HostnameVerifier hostnameVerifier) {
        this(sSLContext, null, null, SSLBufferMode.STATIC, hostnameVerificationPolicy, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sSLContext) {
        this(sSLContext, HttpsSupport.getDefaultHostnameVerifier());
    }

    @Override
    void applyParameters(SSLEngine sSLEngine, SSLParameters sSLParameters, String[] stringArray) {
        if (Conscrypt.isConscrypt((SSLEngine)sSLEngine)) {
            sSLEngine.setSSLParameters(sSLParameters);
            Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])stringArray);
            return;
        }
        sSLParameters.setApplicationProtocols(stringArray);
        sSLEngine.setSSLParameters(sSLParameters);
    }

    @Override
    TlsDetails createTlsDetails(SSLEngine sSLEngine) {
        if (Conscrypt.isConscrypt((SSLEngine)sSLEngine)) {
            return new TlsDetails(sSLEngine.getSession(), Conscrypt.getApplicationProtocol((SSLEngine)sSLEngine));
        }
        return null;
    }

    public static boolean isSupported() {
        try {
            GenericDeclaration genericDeclaration = Class.forName("org.conscrypt.Conscrypt");
            genericDeclaration = genericDeclaration.getMethod("isAvailable", new Class[0]);
            return (Boolean)((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

