/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier$HostNameType;
import org.apache.hc.client5.http.ssl.DistinguishedNameParser;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.client5.http.ssl.SubjectName;
import org.apache.hc.client5.http.utils.DnsUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class DefaultHostnameVerifier
implements HttpClientHostnameVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHostnameVerifier.class);
    private final PublicSuffixMatcher publicSuffixMatcher;

    public DefaultHostnameVerifier(PublicSuffixMatcher publicSuffixMatcher) {
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public DefaultHostnameVerifier() {
        this(null);
    }

    @Override
    public final boolean verify(String string, SSLSession object) {
        try {
            object = object.getPeerCertificates();
            object = (X509Certificate)object[0];
            this.verify(string, (X509Certificate)object);
            return true;
        }
        catch (SSLException sSLException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(sSLException.getMessage(), sSLException);
            }
            return false;
        }
    }

    @Override
    public final void verify(String string, X509Certificate x509Certificate) throws SSLException {
        Object object = DefaultHostnameVerifier.determineHostFormat(string);
        switch (object) {
            case IPv4: {
                DefaultHostnameVerifier.matchIPAddress(string, DefaultHostnameVerifier.getSubjectAltNames(x509Certificate, 7));
                return;
            }
            case IPv6: {
                DefaultHostnameVerifier.matchIPv6Address(string, DefaultHostnameVerifier.getSubjectAltNames(x509Certificate, 7));
                return;
            }
        }
        object = DefaultHostnameVerifier.getSubjectAltNames(x509Certificate, 2);
        if (object.isEmpty()) {
            DefaultHostnameVerifier.matchCN(string, x509Certificate, this.publicSuffixMatcher);
            return;
        }
        DefaultHostnameVerifier.matchDNSName(string, (List<SubjectName>)object, this.publicSuffixMatcher);
    }

    static void matchIPAddress(String string, List<SubjectName> list) throws SSLPeerUnverifiedException {
        for (SubjectName subjectName : list) {
            if (subjectName.getType() != 7 || !string.equals(subjectName.getValue())) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void matchIPv6Address(String string, List<SubjectName> list) throws SSLPeerUnverifiedException {
        String string2 = DefaultHostnameVerifier.normaliseAddress(string);
        for (SubjectName subjectName : list) {
            String string3;
            if (subjectName.getType() != 7 || !string2.equals(string3 = DefaultHostnameVerifier.normaliseAddress(subjectName.getValue()))) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void matchDNSName(String string, List<SubjectName> list, PublicSuffixMatcher publicSuffixMatcher) throws SSLPeerUnverifiedException {
        String string2 = DnsUtils.normalizeUnicode(string);
        for (SubjectName subjectName : list) {
            String string3;
            if (subjectName.getType() != 2 || !DefaultHostnameVerifier.matchIdentity(string2, string3 = DnsUtils.normalizeUnicode(subjectName.getValue()), publicSuffixMatcher, true)) continue;
            return;
        }
        throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match any of the subject alternative names: " + list);
    }

    static void matchCN(String string, X509Certificate object, PublicSuffixMatcher publicSuffixMatcher) throws SSLException {
        String string2;
        object = ((X509Certificate)object).getSubjectX500Principal();
        if ((object = DefaultHostnameVerifier.extractCN(((X500Principal)object).getName("RFC2253"))) == null) {
            throw new SSLPeerUnverifiedException("Certificate subject for <" + string + "> doesn't contain a common name and does not have alternative names");
        }
        String string3 = DnsUtils.normalizeUnicode(string);
        if (!DefaultHostnameVerifier.matchIdentity(string3, string2 = DnsUtils.normalizeUnicode((String)object), publicSuffixMatcher, true)) {
            throw new SSLPeerUnverifiedException("Certificate for <" + string + "> doesn't match common name of the certificate subject: " + (String)object);
        }
    }

    static List<CharSequence> parseFQDN(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 != '.') continue;
            linkedList.addFirst(charSequence.subSequence(n2, i2));
            n2 = i2 + 1;
        }
        linkedList.addFirst(charSequence.subSequence(n2, charSequence.length()));
        return linkedList;
    }

    static boolean matchDomainRoot(String object, String object2) {
        if (object2 == null) {
            return false;
        }
        object = DefaultHostnameVerifier.parseFQDN((CharSequence)object);
        object2 = DefaultHostnameVerifier.parseFQDN((CharSequence)object2);
        if (object.size() >= object2.size()) {
            for (int i2 = 0; i2 < object2.size(); ++i2) {
                CharSequence charSequence;
                CharSequence charSequence2 = (CharSequence)object2.get(i2);
                if (charSequence2.equals(charSequence = (CharSequence)object.get(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean matchIdentity(String string, String string2, PublicSuffixMatcher publicSuffixMatcher, boolean bl2) {
        if (publicSuffixMatcher != null && string.contains(".") && !publicSuffixMatcher.verifyInternal(string2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Public Suffix List verification failed for identity '{}'", (Object)string2);
            }
            return false;
        }
        int n2 = string2.indexOf(42);
        if (n2 != -1) {
            String string3 = string2.substring(0, n2);
            string2 = string2.substring(n2 + 1);
            if (!string3.isEmpty() && !string.startsWith(string3)) {
                return false;
            }
            if (!string2.isEmpty() && !string.endsWith(string2)) {
                return false;
            }
            if (bl2) {
                return !(string = string.substring(string3.length(), string.length() - string2.length())).contains(".");
            }
            return true;
        }
        return string.equalsIgnoreCase(string2);
    }

    static String extractCN(String string) throws SSLException {
        if (string == null) {
            return null;
        }
        Object object = DistinguishedNameParser.INSTANCE.parse(string);
        object = object.iterator();
        while (object.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)object.next();
            if (TextUtils.isBlank(nameValuePair.getName()) || nameValuePair.getValue() == null) {
                throw new SSLException(string + " is not a valid X500 distinguished name");
            }
            if (!nameValuePair.getName().equalsIgnoreCase("cn")) continue;
            return nameValuePair.getValue();
        }
        return null;
    }

    static DefaultHostnameVerifier$HostNameType determineHostFormat(String string) {
        if (InetAddressUtils.isIPv4(string)) {
            return DefaultHostnameVerifier$HostNameType.IPv4;
        }
        String string2 = string;
        if (string2.startsWith("[") && string2.endsWith("]")) {
            string2 = string.substring(1, string.length() - 1);
        }
        if (InetAddressUtils.isIPv6(string2)) {
            return DefaultHostnameVerifier$HostNameType.IPv6;
        }
        return DefaultHostnameVerifier$HostNameType.DNS;
    }

    static List<SubjectName> getSubjectAltNames(X509Certificate x509Certificate) {
        return DefaultHostnameVerifier.getSubjectAltNames(x509Certificate, -1);
    }

    static List<SubjectName> getSubjectAltNames(X509Certificate iterator, int n2) {
        try {
            iterator = ((X509Certificate)((Object)iterator)).getSubjectAlternativeNames();
            if (iterator == null) {
                return Collections.emptyList();
            }
            ArrayList<SubjectName> arrayList = new ArrayList<SubjectName>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object object = (List)iterator.next();
                Integer n3 = object.size() >= 2 ? (Integer)object.get(0) : null;
                if (n3 == null || n3 != n2 && -1 != n2) continue;
                if ((object = object.get(1)) instanceof String) {
                    arrayList.add(new SubjectName((String)object, n3));
                    continue;
                }
                if (!(object instanceof byte[])) continue;
                object = (byte[])object;
                if (n3 != 7) continue;
                if (((Object)object).length == 4) {
                    arrayList.add(new SubjectName(DefaultHostnameVerifier.byteArrayToIp((byte[])object), n3));
                    continue;
                }
                if (((Object)object).length != 16) continue;
                arrayList.add(new SubjectName(DefaultHostnameVerifier.byteArrayToIPv6((byte[])object), n3));
            }
            return arrayList;
        }
        catch (CertificateParsingException certificateParsingException) {
            return Collections.emptyList();
        }
    }

    static String normaliseAddress(String string) {
        if (string == null) {
            return string;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    private static String byteArrayToIp(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Invalid byte array length for IPv4 address");
        }
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private static String byteArrayToIPv6(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Invalid byte array length for IPv6 address");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            stringBuilder.append(String.format("%02x%02x", byArray[i2], byArray[i2 + 1]));
            if (i2 >= byArray.length - 2) continue;
            stringBuilder.append(":");
        }
        return stringBuilder.toString();
    }
}

