/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class ByteArrayBuilder {
    private CharsetEncoder charsetEncoder;
    private ByteBuffer buffer;

    public ByteArrayBuilder() {
    }

    public ByteArrayBuilder(int n2) {
        this.buffer = ByteBuffer.allocate(n2);
    }

    public final int capacity() {
        if (this.buffer != null) {
            return this.buffer.capacity();
        }
        return 0;
    }

    static ByteBuffer ensureFreeCapacity(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return ByteBuffer.allocate(n2);
        }
        if (byteBuffer.remaining() < n2) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.position() + n2);
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    static ByteBuffer encode(ByteBuffer byteBuffer, CharBuffer charBuffer, CharsetEncoder charsetEncoder) throws CharacterCodingException {
        int n2 = (int)((float)charBuffer.remaining() * charsetEncoder.averageBytesPerChar());
        byteBuffer = ByteArrayBuilder.ensureFreeCapacity(byteBuffer, n2);
        while (charBuffer.hasRemaining()) {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            if (coderResult.isUnderflow()) {
                coderResult = charsetEncoder.flush(byteBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (!coderResult.isOverflow()) continue;
            byteBuffer = ByteArrayBuilder.ensureFreeCapacity(byteBuffer, n2);
        }
        return byteBuffer;
    }

    public final void ensureFreeCapacity(int n2) {
        this.buffer = ByteArrayBuilder.ensureFreeCapacity(this.buffer, n2);
    }

    private void doAppend(CharBuffer charBuffer) {
        if (this.charsetEncoder == null) {
            this.charsetEncoder = StandardCharsets.US_ASCII.newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        this.charsetEncoder.reset();
        try {
            this.buffer = ByteArrayBuilder.encode(this.buffer, charBuffer, this.charsetEncoder);
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException("Unexpected character coding error", characterCodingException);
        }
    }

    public final ByteArrayBuilder charset(Charset charset) {
        this.charsetEncoder = charset == null ? null : charset.newEncoder().onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return this;
    }

    public final ByteArrayBuilder append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return this;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        this.ensureFreeCapacity(n3);
        this.buffer.put(byArray, n2, n3);
        return this;
    }

    public final ByteArrayBuilder append(byte[] byArray) {
        if (byArray == null) {
            return this;
        }
        return this.append(byArray, 0, byArray.length);
    }

    public final ByteArrayBuilder append(CharBuffer charBuffer) {
        if (charBuffer == null) {
            return this;
        }
        this.doAppend(charBuffer);
        return this;
    }

    public final ByteArrayBuilder append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return this;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        return this.append(CharBuffer.wrap(cArray, n2, n3));
    }

    public final ByteArrayBuilder append(char[] cArray) {
        if (cArray == null) {
            return this;
        }
        return this.append(cArray, 0, cArray.length);
    }

    public final ByteArrayBuilder append(String string) {
        if (string == null) {
            return this;
        }
        return this.append(CharBuffer.wrap(string));
    }

    public final ByteBuffer toByteBuffer() {
        if (this.buffer != null) {
            return this.buffer.duplicate();
        }
        return ByteBuffer.allocate(0);
    }

    public final byte[] toByteArray() {
        if (this.buffer == null) {
            return new byte[0];
        }
        this.buffer.flip();
        byte[] byArray = new byte[this.buffer.remaining()];
        this.buffer.get(byArray);
        this.buffer.clear();
        return byArray;
    }

    public final void reset() {
        if (this.charsetEncoder != null) {
            this.charsetEncoder.reset();
        }
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    public final String toString() {
        return String.valueOf(this.buffer);
    }
}

