/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

public class URIUtils {
    @Deprecated
    public static URI rewriteURI(URI object, HttpHost object2, boolean bl2) throws URISyntaxException {
        Args.notNull(object, "URI");
        if (((URI)object).isOpaque()) {
            return object;
        }
        object = new URIBuilder((URI)object);
        if (object2 != null) {
            ((URIBuilder)object).setScheme(((HttpHost)object2).getSchemeName());
            ((URIBuilder)object).setHost(((HttpHost)object2).getHostName());
            ((URIBuilder)object).setPort(((HttpHost)object2).getPort());
        } else {
            ((URIBuilder)object).setScheme(null);
            ((URIBuilder)object).setHost((String)null);
            ((URIBuilder)object).setPort(-1);
        }
        if (bl2) {
            ((URIBuilder)object).setFragment(null);
        }
        object2 = ((URIBuilder)object).getPathSegments();
        ArrayList<String> arrayList = new ArrayList<String>((Collection<String>)object2);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.isEmpty() || !iterator.hasNext()) continue;
            iterator.remove();
        }
        if (arrayList.size() != object2.size()) {
            ((URIBuilder)object).setPathSegments(arrayList);
        }
        if (arrayList.isEmpty()) {
            ((URIBuilder)object).setPathSegments("");
        }
        return ((URIBuilder)object).build();
    }

    @Deprecated
    public static URI rewriteURI(URI uRI, HttpHost httpHost) throws URISyntaxException {
        return URIUtils.rewriteURI(uRI, httpHost, false);
    }

    @Deprecated
    public static URI rewriteURI(URI object) throws URISyntaxException {
        Args.notNull(object, "URI");
        if (((URI)object).isOpaque()) {
            return object;
        }
        if (((URIBuilder)(object = new URIBuilder((URI)object))).getUserInfo() != null) {
            ((URIBuilder)object).setUserInfo(null);
        }
        if (((URIBuilder)object).isPathEmpty()) {
            ((URIBuilder)object).setPathSegments("");
        }
        if (((URIBuilder)object).getHost() != null) {
            Object object2 = object;
            ((URIBuilder)object2).setHost(((URIBuilder)object2).getHost().toLowerCase(Locale.ROOT));
        }
        ((URIBuilder)object).setFragment(null);
        return ((URIBuilder)object).build();
    }

    public static URI resolve(URI uRI, String string) {
        return URIUtils.resolve(uRI, URI.create(string));
    }

    public static URI resolve(URI object, URI uRI) {
        Args.notNull(object, "Base URI");
        Args.notNull(uRI, "Reference URI");
        String string = uRI.toASCIIString();
        if (string.startsWith("?")) {
            String string2 = ((URI)object).toASCIIString();
            int n2 = string2.indexOf(63);
            string2 = n2 >= 0 ? string2.substring(0, n2) : string2;
            return URI.create(string2 + string);
        }
        boolean bl2 = string.isEmpty();
        if (bl2) {
            object = ((URI)object).resolve(URI.create("#"));
            object = ((URI)object).toASCIIString();
            object = URI.create(((String)object).substring(0, ((String)object).indexOf(35)));
        } else {
            object = ((URI)object).resolve(uRI);
        }
        try {
            return URIUtils.normalizeSyntax((URI)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    static URI normalizeSyntax(URI object) throws URISyntaxException {
        if (((URI)object).isOpaque() || ((URI)object).getAuthority() == null) {
            return object;
        }
        String string = ((URIBuilder)(object = new URIBuilder((URI)object))).getScheme();
        if (string == null) {
            ((URIBuilder)object).setScheme(URIScheme.HTTP.id);
        } else {
            ((URIBuilder)object).setScheme(TextUtils.toLowerCase(string));
        }
        string = ((URIBuilder)object).getHost();
        if (string != null) {
            ((URIBuilder)object).setHost(TextUtils.toLowerCase(string));
        }
        if (((URIBuilder)object).isPathEmpty()) {
            ((URIBuilder)object).setPathSegments("");
        }
        return ((URIBuilder)object).build();
    }

    public static HttpHost extractHost(URI object) {
        if (object == null) {
            return null;
        }
        object = new URIBuilder((URI)object);
        String string = ((URIBuilder)object).getScheme();
        String string2 = ((URIBuilder)object).getHost();
        int n2 = ((URIBuilder)object).getPort();
        if (!TextUtils.isBlank(string2)) {
            try {
                return new HttpHost(string, string2, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static URI resolve(URI uRI, HttpHost httpHost, List<URI> list) throws URISyntaxException {
        URIBuilder uRIBuilder;
        Args.notNull(uRI, "Request URI");
        if (list == null || list.isEmpty()) {
            uRIBuilder = new URIBuilder(uRI);
        } else {
            List<URI> list2 = list;
            uRIBuilder = new URIBuilder(list2.get(list2.size() - 1));
            String string = uRIBuilder.getFragment();
            for (int i2 = list.size() - 1; string == null && i2 >= 0; --i2) {
                string = list.get(i2).getFragment();
            }
            uRIBuilder.setFragment(string);
        }
        if (uRIBuilder.getFragment() == null) {
            uRIBuilder.setFragment(uRI.getFragment());
        }
        if (httpHost != null && !uRIBuilder.isAbsolute()) {
            uRIBuilder.setScheme(httpHost.getSchemeName());
            uRIBuilder.setHost(httpHost.getHostName());
            uRIBuilder.setPort(httpHost.getPort());
        }
        return uRIBuilder.build();
    }

    @Deprecated
    public static URI create(HttpHost httpHost, String object) throws URISyntaxException {
        object = new URIBuilder((String)object);
        if (httpHost != null) {
            ((URIBuilder)object).setHost(httpHost.getHostName()).setPort(httpHost.getPort()).setScheme(httpHost.getSchemeName());
        }
        return ((URIBuilder)object).build();
    }

    @Deprecated
    public static URI create(String string, URIAuthority uRIAuthority, String object) throws URISyntaxException {
        object = new URIBuilder((String)object);
        if (string != null) {
            ((URIBuilder)object).setScheme(string);
        }
        if (uRIAuthority != null) {
            ((URIBuilder)object).setHost(uRIAuthority.getHostName()).setPort(uRIAuthority.getPort());
        }
        return ((URIBuilder)object).build();
    }

    private URIUtils() {
    }
}

