/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.validator;

import org.apache.hc.client5.http.validator.ValidatorType;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class ETag {
    private final String value;
    private final ValidatorType type;

    public ETag(String string, ValidatorType validatorType) {
        this.value = Args.notNull(string, "Value");
        this.type = Args.notNull(validatorType, "Validator type");
    }

    public ETag(String string) {
        this(string, ValidatorType.STRONG);
    }

    public final ValidatorType getType() {
        return this.type;
    }

    public final String getValue() {
        return this.value;
    }

    public static boolean strongCompare(ETag eTag, ETag eTag2) {
        if (eTag == null || eTag2 == null) {
            return false;
        }
        return eTag.type == ValidatorType.STRONG && eTag.type == eTag2.type && eTag.value.equals(eTag2.value);
    }

    public static boolean weakCompare(ETag eTag, ETag eTag2) {
        if (eTag == null || eTag2 == null) {
            return false;
        }
        return eTag.value.equals(eTag2.value);
    }

    static ETag parse(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor) {
        Tokenizer tokenizer = Tokenizer.INSTANCE;
        tokenizer.skipWhiteSpace(charSequence, tokenizer$Cursor);
        ValidatorType validatorType = ValidatorType.STRONG;
        if (!tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == 'W') {
            Tokenizer$Cursor tokenizer$Cursor2 = tokenizer$Cursor;
            tokenizer$Cursor2.updatePos(tokenizer$Cursor2.getPos() + 1);
            if (!tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == '/') {
                validatorType = ValidatorType.WEAK;
                Tokenizer$Cursor tokenizer$Cursor3 = tokenizer$Cursor;
                tokenizer$Cursor3.updatePos(tokenizer$Cursor3.getPos() + 1);
            } else {
                return null;
            }
        }
        CharSequence charSequence2 = null;
        if (!tokenizer$Cursor.atEnd() && charSequence.charAt(tokenizer$Cursor.getPos()) == '\"') {
            Tokenizer$Cursor tokenizer$Cursor4 = tokenizer$Cursor;
            tokenizer$Cursor4.updatePos(tokenizer$Cursor4.getPos() + 1);
            charSequence2 = new StringBuilder();
            while (true) {
                if (tokenizer$Cursor.atEnd()) {
                    return null;
                }
                char c2 = charSequence.charAt(tokenizer$Cursor.getPos());
                Tokenizer$Cursor tokenizer$Cursor5 = tokenizer$Cursor;
                tokenizer$Cursor5.updatePos(tokenizer$Cursor5.getPos() + 1);
                if (c2 == '\"') break;
                charSequence2.append(c2);
            }
            charSequence2 = charSequence2.toString();
        }
        tokenizer.skipWhiteSpace(charSequence, tokenizer$Cursor);
        if (!tokenizer$Cursor.atEnd()) {
            return null;
        }
        return new ETag((String)charSequence2, validatorType);
    }

    public static ETag parse(String string) {
        if (string == null) {
            return null;
        }
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        return ETag.parse(string, tokenizer$Cursor);
    }

    public static ETag parse(Header object) {
        if (object == null) {
            return null;
        }
        if ((object = object.getValue()) == null) {
            return null;
        }
        return ETag.parse((String)object);
    }

    public static ETag get(MessageHeaders messageHeaders) {
        if (messageHeaders == null) {
            return null;
        }
        return ETag.parse(messageHeaders.getFirstHeader("ETag"));
    }

    @Internal
    public final void format(CharArrayBuffer charArrayBuffer) {
        if (charArrayBuffer == null) {
            return;
        }
        if (this.type == ValidatorType.WEAK) {
            charArrayBuffer.append("W/");
        }
        charArrayBuffer.append('\"');
        charArrayBuffer.append(this.value);
        charArrayBuffer.append('\"');
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ETag) {
            object = (ETag)object;
            return this.type == ((ETag)object).type && this.value.equals(((ETag)object).value);
        }
        return false;
    }

    public final int hashCode() {
        int n2 = LangUtils.hashCode(17, (Object)this.type);
        n2 = LangUtils.hashCode(n2, this.value);
        return n2;
    }

    public final String toString() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        this.format(charArrayBuffer);
        return charArrayBuffer.toString();
    }
}

