/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeoutValueException;

public class BasicFuture<T>
implements Future<T>,
Cancellable {
    private final FutureCallback<T> callback;
    private volatile boolean completed;
    private volatile boolean cancelled;
    private volatile T result;
    private volatile Exception ex;
    private final ReentrantLock lock;
    private final Condition condition;

    public BasicFuture(FutureCallback<T> futureCallback) {
        this.callback = futureCallback;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completed;
    }

    private T getResult() throws ExecutionException {
        if (this.ex != null) {
            throw new ExecutionException(this.ex);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.result;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.completed) {
                this.condition.await();
            }
            T t2 = this.getResult();
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Args.notNull(timeUnit, "Time unit");
        long l3 = timeUnit.toMillis(l2);
        long l4 = l3 <= 0L ? 0L : System.currentTimeMillis();
        long l5 = l3;
        try {
            this.lock.lock();
            if (this.completed) {
                T t2 = this.getResult();
                return t2;
            }
            if (l5 <= 0L) {
                long l6 = l3;
                throw TimeoutValueException.fromMilliseconds(l6, l6 + Math.abs(l5));
            }
            do {
                this.condition.await(l5, TimeUnit.MILLISECONDS);
                if (!this.completed) continue;
                T t3 = this.getResult();
                return t3;
            } while ((l5 = l3 - (System.currentTimeMillis() - l4)) > 0L);
            long l7 = l3;
            throw TimeoutValueException.fromMilliseconds(l7, l7 + Math.abs(l5));
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean completed(T t2) {
        this.lock.lock();
        try {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.result = t2;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.completed(t2);
        }
        return true;
    }

    public boolean failed(Exception exception) {
        this.lock.lock();
        try {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.ex = exception;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.failed(exception);
        }
        return true;
    }

    @Override
    public boolean cancel(boolean bl2) {
        this.lock.lock();
        try {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            this.cancelled = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        if (this.callback != null) {
            this.callback.cancelled();
        }
        return true;
    }

    @Override
    public boolean cancel() {
        return this.cancel(true);
    }
}

