/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.atomic.AtomicMarkableReference;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.util.Args;

public final class ComplexCancellable
implements CancellableDependency {
    private final AtomicMarkableReference<Cancellable> dependencyRef = new AtomicMarkableReference<Object>(null, false);

    @Override
    public final boolean isCancelled() {
        return this.dependencyRef.isMarked();
    }

    @Override
    public final void setDependency(Cancellable cancellable) {
        Args.notNull(cancellable, "dependency");
        Cancellable cancellable2 = this.dependencyRef.getReference();
        if (!this.dependencyRef.compareAndSet(cancellable2, cancellable, false, false)) {
            cancellable.cancel();
        }
    }

    @Override
    public final boolean cancel() {
        while (!this.dependencyRef.isMarked()) {
            Cancellable cancellable;
            Cancellable cancellable2 = cancellable = this.dependencyRef.getReference();
            if (!this.dependencyRef.compareAndSet(cancellable2, cancellable2, false, true)) continue;
            if (cancellable != null) {
                cancellable.cancel();
            }
            return true;
        }
        return false;
    }
}

