/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.net.SocketAddress;
import org.apache.hc.core5.http.HttpConnectionMetrics;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.Timeout;

public abstract class EndpointDetails
implements HttpConnectionMetrics {
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final Timeout socketTimeout;

    protected EndpointDetails(SocketAddress socketAddress, SocketAddress socketAddress2, Timeout timeout) {
        this.remoteAddress = socketAddress;
        this.localAddress = socketAddress2;
        this.socketTimeout = timeout;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public abstract long getRequestCount();

    @Override
    public abstract long getResponseCount();

    @Override
    public abstract long getSentBytesCount();

    @Override
    public abstract long getReceivedBytesCount();

    public Timeout getSocketTimeout() {
        return this.socketTimeout;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(90);
        InetAddressUtils.formatAddress(stringBuilder, this.localAddress);
        stringBuilder.append("<->");
        InetAddressUtils.formatAddress(stringBuilder, this.remoteAddress);
        return stringBuilder.toString();
    }
}

