/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.util.Locale;
import org.apache.hc.core5.util.Args;

public enum Method {
    GET(true, true),
    HEAD(true, true),
    POST(false, false),
    PUT(false, true),
    DELETE(false, true),
    CONNECT(false, false),
    TRACE(true, true),
    OPTIONS(true, true),
    PATCH(false, false);

    private final boolean safe;
    private final boolean idempotent;

    private Method(boolean bl2, boolean bl3) {
        this.safe = bl2;
        this.idempotent = bl3;
    }

    public final boolean isSafe() {
        return this.safe;
    }

    public final boolean isIdempotent() {
        return this.idempotent;
    }

    public static boolean isSafe(String string) {
        if (string == null) {
            return false;
        }
        try {
            return Method.normalizedValueOf((String)string).safe;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isIdempotent(String string) {
        if (string == null) {
            return false;
        }
        try {
            return Method.normalizedValueOf((String)string).idempotent;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static Method normalizedValueOf(String string) {
        return Method.valueOf(Args.notNull(string, "method").toUpperCase(Locale.ROOT));
    }

    public final boolean isSame(String string) {
        if (string == null) {
            return false;
        }
        return this.name().equalsIgnoreCase(string);
    }
}

