/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.Serializable;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.ProtocolVersionParser;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Tokenizer;
import org.apache.hc.core5.util.Tokenizer$Cursor;
import org.apache.hc.core5.util.Tokenizer$Delimiter;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ProtocolVersion
implements Serializable {
    private static final long serialVersionUID = 8950662842175091068L;
    private final String protocol;
    private final int major;
    private final int minor;

    public ProtocolVersion(String string, int n2, int n3) {
        this.protocol = Args.notNull(string, "Protocol name");
        this.major = Args.notNegative(n2, "Protocol major version");
        this.minor = Args.notNegative(n3, "Protocol minor version");
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int hashCode() {
        return this.protocol.hashCode() ^ this.major * 100000 ^ this.minor;
    }

    public final boolean equals(int n2, int n3) {
        return this.major == n2 && this.minor == n3;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProtocolVersion)) {
            return false;
        }
        object = (ProtocolVersion)object;
        return this.protocol.equals(((ProtocolVersion)object).protocol) && this.major == ((ProtocolVersion)object).major && this.minor == ((ProtocolVersion)object).minor;
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.protocol);
        stringBuilder.append('/');
        stringBuilder.append(this.major);
        stringBuilder.append('.');
        stringBuilder.append(this.minor);
        return stringBuilder.toString();
    }

    public boolean isComparable(ProtocolVersion protocolVersion) {
        return protocolVersion != null && this.protocol.equals(protocolVersion.protocol);
    }

    public int compareToVersion(ProtocolVersion protocolVersion) {
        Args.notNull(protocolVersion, "Protocol version");
        Args.check(this.protocol.equals(protocolVersion.protocol), "Versions for different protocols cannot be compared: %s %s", this, protocolVersion);
        int n2 = this.getMajor() - protocolVersion.getMajor();
        if (n2 == 0) {
            n2 = this.getMinor() - protocolVersion.getMinor();
        }
        return n2;
    }

    public final boolean greaterEquals(ProtocolVersion protocolVersion) {
        return this.isComparable(protocolVersion) && this.compareToVersion(protocolVersion) >= 0;
    }

    public final boolean lessEquals(ProtocolVersion protocolVersion) {
        return this.isComparable(protocolVersion) && this.compareToVersion(protocolVersion) <= 0;
    }

    @Internal
    public static ProtocolVersion parse(CharSequence charSequence, Tokenizer$Cursor tokenizer$Cursor, Tokenizer$Delimiter tokenizer$Delimiter) throws ParseException {
        return ProtocolVersionParser.INSTANCE.parse(charSequence, tokenizer$Cursor, tokenizer$Delimiter);
    }

    public static ProtocolVersion parse(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        Tokenizer$Cursor tokenizer$Cursor = new Tokenizer$Cursor(0, string.length());
        ProtocolVersion protocolVersion = ProtocolVersionParser.INSTANCE.parse((CharSequence)string, tokenizer$Cursor, null);
        Tokenizer.INSTANCE.skipWhiteSpace(string, tokenizer$Cursor);
        if (!tokenizer$Cursor.atEnd()) {
            throw new ParseException("Invalid protocol version; trailing content");
        }
        return protocolVersion;
    }

    public String toString() {
        return this.format();
    }
}

