/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.http.HttpConnectionMetrics;
import org.apache.hc.core5.http.io.HttpTransportMetrics;

public final class BasicHttpConnectionMetrics
implements HttpConnectionMetrics {
    private final HttpTransportMetrics inTransportMetric;
    private final HttpTransportMetrics outTransportMetric;
    private final AtomicLong requestCount;
    private final AtomicLong responseCount;

    public BasicHttpConnectionMetrics(HttpTransportMetrics httpTransportMetrics, HttpTransportMetrics httpTransportMetrics2) {
        this.inTransportMetric = httpTransportMetrics;
        this.outTransportMetric = httpTransportMetrics2;
        this.requestCount = new AtomicLong(0L);
        this.responseCount = new AtomicLong(0L);
    }

    @Override
    public final long getReceivedBytesCount() {
        if (this.inTransportMetric != null) {
            return this.inTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    @Override
    public final long getSentBytesCount() {
        if (this.outTransportMetric != null) {
            return this.outTransportMetric.getBytesTransferred();
        }
        return -1L;
    }

    @Override
    public final long getRequestCount() {
        return this.requestCount.get();
    }

    public final void incrementRequestCount() {
        this.requestCount.incrementAndGet();
    }

    @Override
    public final long getResponseCount() {
        return this.responseCount.get();
    }

    public final void incrementResponseCount() {
        this.responseCount.incrementAndGet();
    }
}

