/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl;

import java.util.Iterator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicTokenIterator;
import org.apache.hc.core5.http.message.MessageSupport;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest object, HttpResponse httpResponse, HttpContext httpContext) {
        Object object2;
        Object object3;
        Args.notNull(httpResponse, "HTTP response");
        if (object != null) {
            if (object.containsHeader("Content-Length") && object.containsHeader("Transfer-Encoding")) {
                return false;
            }
            object3 = MessageSupport.iterateTokens((MessageHeaders)object, "Connection");
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!"close".equalsIgnoreCase((String)object2)) continue;
                return false;
            }
        }
        if ((object3 = httpResponse.getFirstHeader("Transfer-Encoding")) == null && MessageSupport.canResponseHaveBody(object != null ? object.getMethod() : null, httpResponse) && httpResponse.countHeaders("Content-Length") != 1) {
            return false;
        }
        object2 = httpResponse.getVersion() != null ? httpResponse.getVersion() : httpContext.getProtocolVersion();
        if (((ProtocolVersion)object2).lessEquals(HttpVersion.HTTP_1_0) && object3 != null) {
            return false;
        }
        if (httpResponse.getCode() == 204) {
            object = httpResponse.getFirstHeader("Content-Length");
            if (object != null) {
                try {
                    long l2 = Long.parseLong(object.getValue());
                    if (l2 > 0L) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (httpResponse.containsHeader("Transfer-Encoding")) {
                return false;
            }
        }
        if (!(object = httpResponse.headerIterator("Connection")).hasNext()) {
            object = httpResponse.headerIterator("Proxy-Connection");
        }
        if (object.hasNext()) {
            if (((ProtocolVersion)object2).greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator basicTokenIterator = new BasicTokenIterator((Iterator<? extends Header>)object);
                while (basicTokenIterator.hasNext()) {
                    String string = (String)basicTokenIterator.next();
                    if (!"close".equalsIgnoreCase(string)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator basicTokenIterator = new BasicTokenIterator((Iterator<? extends Header>)object);
            while (basicTokenIterator.hasNext()) {
                String string = (String)basicTokenIterator.next();
                if (!"keep-alive".equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        return ((ProtocolVersion)object2).greaterEquals(HttpVersion.HTTP_1_1);
    }
}

