/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.NamedElementChain;
import org.apache.hc.core5.http.config.NamedElementChain$Node;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.impl.bootstrap.FilterEntry;
import org.apache.hc.core5.http.impl.bootstrap.FilterEntry$Position;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandlerFactory;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.impl.routing.RequestRouter$Entry;
import org.apache.hc.core5.http.nio.AsyncFilterHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.LookupRegistry;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http.protocol.UriPatternMatcher;
import org.apache.hc.core5.http.protocol.UriPatternType;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class AsyncServerBootstrap {
    private final List<RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>> routeEntries = new ArrayList<RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> requestRouter;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private IOReactorConfig ioReactorConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private Http1StreamListener streamListener;

    private AsyncServerBootstrap() {
    }

    public static AsyncServerBootstrap bootstrap() {
        return new AsyncServerBootstrap();
    }

    public final AsyncServerBootstrap setCanonicalHostName(String string) {
        this.canonicalHostName = string;
        return this;
    }

    public final AsyncServerBootstrap setIOReactorConfig(IOReactorConfig iOReactorConfig) {
        this.ioReactorConfig = iOReactorConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final AsyncServerBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final AsyncServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connectionReuseStrategy) {
        this.connStrategy = connectionReuseStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsHandshakeTimeout(Timeout timeout) {
        this.handshakeTimeout = timeout;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionDecorator(Decorator<IOSession> decorator) {
        this.ioSessionDecorator = decorator;
        return this;
    }

    public final AsyncServerBootstrap setExceptionCallback(Callback<Exception> callback) {
        this.exceptionCallback = callback;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionListener(IOSessionListener iOSessionListener) {
        this.sessionListener = iOSessionListener;
        return this;
    }

    @Deprecated
    public final AsyncServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final AsyncServerBootstrap setRequestRouter(HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper) {
        this.requestRouter = httpRequestMapper;
        return this;
    }

    public final AsyncServerBootstrap setStreamListener(Http1StreamListener http1StreamListener) {
        this.streamListener = http1StreamListener;
        return this;
    }

    public final AsyncServerBootstrap register(String string, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(string, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>(string, supplier));
        return this;
    }

    public final AsyncServerBootstrap register(String string, String string2, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(string, "Hostname");
        Args.notBlank(string2, "URI pattern");
        Args.notNull(supplier, "Exchange handler supplier");
        this.routeEntries.add(new RequestRouter$Entry<Supplier<AsyncServerExchangeHandler>>(string, string2, supplier));
        return this;
    }

    @Deprecated
    public final AsyncServerBootstrap registerVirtual(String string, String string2, Supplier<AsyncServerExchangeHandler> supplier) {
        return this.register(string, string2, supplier);
    }

    public final <T> AsyncServerBootstrap register(String string, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        this.register(string, () -> new BasicServerExchangeHandler(asyncServerRequestHandler));
        return this;
    }

    public final <T> AsyncServerBootstrap register(String string, String string2, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        this.register(string, string2, () -> new BasicServerExchangeHandler(asyncServerRequestHandler));
        return this;
    }

    @Deprecated
    public final <T> AsyncServerBootstrap registerVirtual(String string, String string2, AsyncServerRequestHandler<T> asyncServerRequestHandler) {
        return this.register(string, string2, asyncServerRequestHandler);
    }

    public final AsyncServerBootstrap addFilterBefore(String string, String string2, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.BEFORE, string2, asyncFilterHandler, string));
        return this;
    }

    public final AsyncServerBootstrap addFilterAfter(String string, String string2, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notBlank(string2, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.AFTER, string2, asyncFilterHandler, string));
        return this;
    }

    public final AsyncServerBootstrap replaceFilter(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notBlank(string, "Existing");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.REPLACE, string, asyncFilterHandler, string));
        return this;
    }

    public final AsyncServerBootstrap addFilterFirst(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.FIRST, string, asyncFilterHandler, null));
        return this;
    }

    public final AsyncServerBootstrap addFilterLast(String string, AsyncFilterHandler asyncFilterHandler) {
        Args.notNull(string, "Name");
        Args.notNull(asyncFilterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry$Position.LAST, string, asyncFilterHandler, null));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpAsyncServer create() {
        Object object;
        HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper3;
        HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper2 = httpRequestMapper3 = this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName();
        if (this.lookupRegistry != null && this.requestRouter == null) {
            httpRequestMapper3 = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>((String)((Object)httpRequestMapper3), () -> {
                if (this.lookupRegistry != null) {
                    return this.lookupRegistry;
                }
                return new UriPatternMatcher();
            });
            for (RequestRouter$Entry object22 : this.routeEntries) {
                ((RequestHandlerRegistry)httpRequestMapper3).register(object22.uriAuthority != null ? object22.uriAuthority.getHostName() : null, (String)object22.route.pattern, (Supplier<AsyncServerExchangeHandler>)object22.route.handler);
            }
        } else {
            httpRequestMapper3 = this.routeEntries.isEmpty() ? this.requestRouter : RequestRouter.create(new URIAuthority((String)((Object)httpRequestMapper3)), UriPatternType.URI_PATTERN, this.routeEntries, RequestRouter.IGNORE_PORT_AUTHORITY_RESOLVER, this.requestRouter);
        }
        if (!this.filters.isEmpty()) {
            void var3_6;
            object = new NamedElementChain<TerminalAsyncServerFilter>();
            ((NamedElementChain)object).addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(httpRequestMapper3)), StandardFilter.MAIN_HANDLER.name());
            ((NamedElementChain)object).addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (HttpRequestMapper<Supplier<AsyncServerExchangeHandler>> httpRequestMapper3 : this.filters) {
                switch (((FilterEntry)((Object)httpRequestMapper3)).position) {
                    case AFTER: {
                        ((NamedElementChain)object).addAfter(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case BEFORE: {
                        ((NamedElementChain)object).addBefore(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case REPLACE: {
                        ((NamedElementChain)object).replace(((FilterEntry)((Object)httpRequestMapper3)).existing, ((FilterEntry)((Object)httpRequestMapper3)).filterHandler);
                        break;
                    }
                    case FIRST: {
                        ((NamedElementChain)object).addFirst(((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                        break;
                    }
                    case LAST: {
                        ((NamedElementChain)object).addBefore(StandardFilter.MAIN_HANDLER.name(), ((FilterEntry)((Object)httpRequestMapper3)).filterHandler, ((FilterEntry)((Object)httpRequestMapper3)).name);
                    }
                }
            }
            NamedElementChain$Node namedElementChain$Node = ((NamedElementChain)object).getLast();
            httpRequestMapper3 = null;
            while (var3_6 != null) {
                httpRequestMapper3 = new AsyncServerFilterChainElement((AsyncFilterHandler)var3_6.getValue(), (AsyncServerFilterChainElement)((Object)httpRequestMapper3));
                NamedElementChain$Node namedElementChain$Node2 = var3_6.getPrevious();
            }
            httpRequestMapper3 = new AsyncServerFilterChainExchangeHandlerFactory((AsyncServerFilterChainElement)((Object)httpRequestMapper3), this.exceptionCallback);
        } else {
            httpRequestMapper3 = new DefaultAsyncResponseExchangeHandlerFactory(httpRequestMapper3, asyncServerExchangeHandler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)asyncServerExchangeHandler, this.exceptionCallback));
        }
        DefaultContentLengthStrategy defaultContentLengthStrategy = DefaultContentLengthStrategy.INSTANCE;
        object = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), (HandlerFactory<AsyncServerExchangeHandler>)((Object)httpRequestMapper3), this.http1Config, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.connStrategy != null ? this.connStrategy : DefaultConnectionReuseStrategy.INSTANCE, new DefaultHttpRequestParserFactory(this.http1Config), new DefaultHttpResponseWriterFactory(this.http1Config), defaultContentLengthStrategy, defaultContentLengthStrategy, this.streamListener, this.exceptionCallback);
        ServerHttp1IOEventHandlerFactory serverHttp1IOEventHandlerFactory = new ServerHttp1IOEventHandlerFactory((ServerHttp1StreamDuplexerFactory)object, this.tlsStrategy, this.handshakeTimeout);
        return new HttpAsyncServer(serverHttp1IOEventHandlerFactory, this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener);
    }
}

