/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester$1;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester$PoolEntryHolder;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnectionFactory;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.io.HttpClientConnection;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpResponseInformationCallback;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.ssl.SSLSessionVerifier;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.io.SocketSupport;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class HttpRequester
implements ModalCloseable,
ConnPoolControl<HttpHost> {
    private final HttpRequestExecutor requestExecutor;
    private final HttpProcessor httpProcessor;
    private final ManagedConnPool<HttpHost, HttpClientConnection> connPool;
    private final SocketConfig socketConfig;
    private final HttpConnectionFactory<? extends HttpClientConnection> connectFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Callback<SSLParameters> sslSetupHandler;
    private final SSLSessionVerifier sslSessionVerifier;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public HttpRequester(HttpRequestExecutor httpRequestExecutor, HttpProcessor httpProcessor, ManagedConnPool<HttpHost, HttpClientConnection> managedConnPool, SocketConfig socketConfig, HttpConnectionFactory<? extends HttpClientConnection> defaultBHttpClientConnectionFactory, SSLSocketFactory sSLSocketFactory, Callback<SSLParameters> callback, SSLSessionVerifier sSLSessionVerifier, Resolver<HttpHost, InetSocketAddress> defaultAddressResolver) {
        this.requestExecutor = Args.notNull(httpRequestExecutor, "Request executor");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.connPool = Args.notNull(managedConnPool, "Connection pool");
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
        this.connectFactory = defaultBHttpClientConnectionFactory != null ? defaultBHttpClientConnectionFactory : new DefaultBHttpClientConnectionFactory(Http1Config.DEFAULT, CharCodingConfig.DEFAULT);
        this.sslSocketFactory = sSLSocketFactory != null ? sSLSocketFactory : (SSLSocketFactory)SSLSocketFactory.getDefault();
        this.sslSetupHandler = callback;
        this.sslSessionVerifier = sSLSessionVerifier;
        this.addressResolver = defaultAddressResolver != null ? defaultAddressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    public PoolStats getTotalStats() {
        return this.connPool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpHost httpHost) {
        return this.connPool.getStats(httpHost);
    }

    @Override
    public void setMaxTotal(int n2) {
        this.connPool.setMaxTotal(n2);
    }

    @Override
    public int getMaxTotal() {
        return this.connPool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int n2) {
        this.connPool.setDefaultMaxPerRoute(n2);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.connPool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(HttpHost httpHost, int n2) {
        this.connPool.setMaxPerRoute(httpHost, n2);
    }

    @Override
    public int getMaxPerRoute(HttpHost httpHost) {
        return this.connPool.getMaxPerRoute(httpHost);
    }

    @Override
    public void closeIdle(TimeValue timeValue) {
        this.connPool.closeIdle(timeValue);
    }

    @Override
    public void closeExpired() {
        this.connPool.closeExpired();
    }

    @Override
    public Set<HttpHost> getRoutes() {
        return this.connPool.getRoutes();
    }

    public ClassicHttpResponse execute(HttpClientConnection closeable, ClassicHttpRequest classicHttpRequest, HttpResponseInformationCallback httpResponseInformationCallback, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(closeable, "HTTP connection");
        Args.notNull(classicHttpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        if (!closeable.isOpen()) {
            throw new ConnectionClosedException();
        }
        this.requestExecutor.preProcess(classicHttpRequest, this.httpProcessor, httpContext);
        closeable = this.requestExecutor.execute(classicHttpRequest, (HttpClientConnection)closeable, httpResponseInformationCallback, httpContext);
        this.requestExecutor.postProcess((ClassicHttpResponse)closeable, this.httpProcessor, httpContext);
        return closeable;
    }

    public ClassicHttpResponse execute(HttpClientConnection httpClientConnection, ClassicHttpRequest classicHttpRequest, HttpContext httpContext) throws HttpException, IOException {
        return this.execute(httpClientConnection, classicHttpRequest, null, httpContext);
    }

    public boolean keepAlive(HttpClientConnection httpClientConnection, ClassicHttpRequest classicHttpRequest, ClassicHttpResponse classicHttpResponse, HttpContext httpContext) throws IOException {
        boolean bl2 = this.requestExecutor.keepAlive(classicHttpRequest, classicHttpResponse, httpClientConnection, httpContext);
        if (!bl2) {
            httpClientConnection.close();
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(HttpClientConnection httpClientConnection, ClassicHttpRequest classicHttpRequest, HttpContext httpContext, HttpClientResponseHandler<T> object) throws HttpException, IOException {
        try {
            Object object2;
            ClassicHttpResponse classicHttpResponse = this.execute(httpClientConnection, classicHttpRequest, httpContext);
            Throwable throwable = null;
            try {
                object = object.handleResponse(classicHttpResponse);
                EntityUtils.consume(classicHttpResponse.getEntity());
                boolean bl2 = this.requestExecutor.keepAlive(classicHttpRequest, classicHttpResponse, httpClientConnection, httpContext);
                if (!bl2) {
                    httpClientConnection.close();
                }
                object2 = object;
                if (classicHttpResponse == null) return (T)object2;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (classicHttpResponse == null) throw throwable3;
                    if (throwable == null) {
                        classicHttpResponse.close();
                        throw throwable3;
                    }
                    try {
                        classicHttpResponse.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            classicHttpResponse.close();
            return (T)object2;
        }
        catch (IOException | RuntimeException | HttpException exception) {
            httpClientConnection.close(CloseMode.IMMEDIATE);
            throw exception;
        }
    }

    private HttpClientConnection createConnection(Socket socket, HttpHost httpHost) throws IOException {
        int n2;
        socket.setSoTimeout(this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        socket.setReuseAddress(this.socketConfig.isSoReuseAddress());
        socket.setTcpNoDelay(this.socketConfig.isTcpNoDelay());
        socket.setKeepAlive(this.socketConfig.isSoKeepAlive());
        if (this.socketConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
        }
        if (this.socketConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.socketConfig.getSndBufSize());
        }
        if (this.socketConfig.getTcpKeepIdle() > 0) {
            SocketSupport.setOption(socket, "TCP_KEEPIDLE", this.socketConfig.getTcpKeepIdle());
        }
        if (this.socketConfig.getTcpKeepInterval() > 0) {
            SocketSupport.setOption(socket, "TCP_KEEPINTERVAL", this.socketConfig.getTcpKeepInterval());
        }
        if (this.socketConfig.getTcpKeepCount() > 0) {
            SocketSupport.setOption(socket, "TCP_KEEPCOUNT", this.socketConfig.getTcpKeepCount());
        }
        if ((n2 = this.socketConfig.getSoLinger().toMillisecondsIntBound()) >= 0) {
            socket.setSoLinger(true, n2);
        }
        Object object = this.addressResolver.resolve(httpHost);
        socket.connect((SocketAddress)object, this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        if (URIScheme.HTTPS.same(httpHost.getSchemeName())) {
            Object object2;
            object = (SSLSocket)this.sslSocketFactory.createSocket(socket, httpHost.getHostName(), ((InetSocketAddress)object).getPort(), false);
            if (this.sslSetupHandler != null) {
                object2 = ((SSLSocket)object).getSSLParameters();
                this.sslSetupHandler.execute((SSLParameters)object2);
                ((SSLSocket)object).setSSLParameters((SSLParameters)object2);
            }
            try {
                ((SSLSocket)object).startHandshake();
                object2 = ((SSLSocket)object).getSession();
                if (object2 == null) {
                    throw new SSLHandshakeException("SSL session not available");
                }
                if (this.sslSessionVerifier != null) {
                    this.sslSessionVerifier.verify(httpHost, (SSLSession)object2);
                }
                return this.connectFactory.createConnection((SSLSocket)object, socket);
            }
            catch (IOException iOException) {
                Closer.closeQuietly((Closeable)object);
                throw iOException;
            }
        }
        return this.connectFactory.createConnection(socket);
    }

    public ClassicHttpResponse execute(HttpHost object, ClassicHttpRequest classicHttpRequest, HttpResponseInformationCallback httpResponseInformationCallback, Timeout object2, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(object, "HTTP host");
        Args.notNull(classicHttpRequest, "HTTP request");
        Object object3 = this.connPool.lease((HttpHost)object, null, (Timeout)object2, null);
        object2 = Timeout.defaultsToInfinite((Timeout)object2);
        try {
            object2 = object3.get(((TimeValue)object2).getDuration(), ((TimeValue)object2).getTimeUnit());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            throw new HttpException("Unexpected failure leasing connection", executionException);
        }
        catch (TimeoutException timeoutException) {
            throw new ConnectionRequestTimeoutException("Connection request timeout");
        }
        object3 = new HttpRequester$PoolEntryHolder(this, (PoolEntry<HttpHost, HttpClientConnection>)object2);
        try {
            Closeable closeable;
            HttpClientConnection httpClientConnection = (HttpClientConnection)((PoolEntry)object2).getConnection();
            if (httpClientConnection == null) {
                closeable = this.socketConfig.getSocksProxyAddress() != null ? new Socket(new Proxy(Proxy.Type.SOCKS, this.socketConfig.getSocksProxyAddress())) : new Socket();
                try {
                    httpClientConnection = this.createConnection((Socket)closeable, (HttpHost)object);
                    ((PoolEntry)object2).assignConnection(httpClientConnection);
                }
                catch (IOException | RuntimeException exception) {
                    Closer.closeQuietly(closeable);
                    throw exception;
                }
            }
            if (classicHttpRequest.getAuthority() == null) {
                classicHttpRequest.setAuthority(new URIAuthority(((HttpHost)object).getHostName(), ((HttpHost)object).getPort()));
            }
            if ((object = (closeable = this.execute(httpClientConnection, classicHttpRequest, httpResponseInformationCallback, httpContext)).getEntity()) != null) {
                closeable.setEntity(new HttpRequester$1(this, (HttpEntity)object, (HttpRequester$PoolEntryHolder)object3, classicHttpRequest, (ClassicHttpResponse)closeable, httpContext));
            } else {
                object = ((HttpRequester$PoolEntryHolder)object3).getConnection();
                if (!this.requestExecutor.keepAlive(classicHttpRequest, (ClassicHttpResponse)closeable, (HttpClientConnection)object, httpContext)) {
                    object.close();
                }
                ((HttpRequester$PoolEntryHolder)object3).releaseConnection();
            }
            return closeable;
        }
        catch (IOException | RuntimeException | HttpException exception) {
            ((HttpRequester$PoolEntryHolder)object3).discardConnection();
            throw exception;
        }
    }

    public ClassicHttpResponse execute(HttpHost httpHost, ClassicHttpRequest classicHttpRequest, Timeout timeout, HttpContext httpContext) throws HttpException, IOException {
        return this.execute(httpHost, classicHttpRequest, null, timeout, httpContext);
    }

    public <T> T execute(HttpHost object, ClassicHttpRequest object2, Timeout object3, HttpContext httpContext, HttpClientResponseHandler<T> httpClientResponseHandler) throws HttpException, IOException {
        block9: {
            object = this.execute((HttpHost)object, (ClassicHttpRequest)object2, null, (Timeout)object3, httpContext);
            object2 = null;
            try {
                object3 = httpClientResponseHandler.handleResponse((ClassicHttpResponse)object);
                EntityUtils.consume(object.getEntity());
                if (object == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    object3 = throwable;
                    object2 = throwable;
                    throw object3;
                }
                catch (Throwable throwable2) {
                    if (object != null) {
                        if (object2 != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object2).addSuppressed(throwable3);
                            }
                        } else {
                            object.close();
                        }
                    }
                    throw throwable2;
                }
            }
            object.close();
        }
        return (T)object3;
    }

    public ConnPoolControl<HttpHost> getConnPoolControl() {
        return this.connPool;
    }

    @Override
    public void close(CloseMode closeMode) {
        this.connPool.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.connPool.close();
    }

    static /* synthetic */ HttpRequestExecutor access$000(HttpRequester httpRequester) {
        return httpRequester.requestExecutor;
    }

    static /* synthetic */ ManagedConnPool access$300(HttpRequester httpRequester) {
        return httpRequester.connPool;
    }
}

