/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.impl.bootstrap.Worker;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.io.SocketSupport;

class RequestListener
implements Runnable {
    private final SocketConfig socketConfig;
    private final ServerSocket serverSocket;
    private final HttpService httpService;
    private final HttpConnectionFactory<? extends HttpServerConnection> connectionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final Callback<SSLParameters> sslSetupHandler;
    private final ExceptionListener exceptionListener;
    private final ExecutorService executorService;
    private final AtomicBoolean terminated;

    public RequestListener(SocketConfig socketConfig, ServerSocket serverSocket, HttpService httpService, HttpConnectionFactory<? extends HttpServerConnection> httpConnectionFactory, SSLSocketFactory sSLSocketFactory, Callback<SSLParameters> callback, ExceptionListener exceptionListener, ExecutorService executorService) {
        this.socketConfig = socketConfig;
        this.serverSocket = serverSocket;
        this.httpService = httpService;
        this.connectionFactory = httpConnectionFactory;
        this.sslSocketFactory = sSLSocketFactory;
        this.sslSetupHandler = callback;
        this.exceptionListener = exceptionListener;
        this.executorService = executorService;
        this.terminated = new AtomicBoolean();
    }

    private HttpServerConnection createConnection(Socket socket) throws IOException {
        socket.setSoTimeout(this.socketConfig.getSoTimeout().toMillisecondsIntBound());
        socket.setKeepAlive(this.socketConfig.isSoKeepAlive());
        socket.setTcpNoDelay(this.socketConfig.isTcpNoDelay());
        if (this.socketConfig.getRcvBufSize() > 0) {
            socket.setReceiveBufferSize(this.socketConfig.getRcvBufSize());
        }
        if (this.socketConfig.getSndBufSize() > 0) {
            socket.setSendBufferSize(this.socketConfig.getSndBufSize());
        }
        if (this.socketConfig.getSoLinger().toSeconds() >= 0L) {
            socket.setSoLinger(true, this.socketConfig.getSoLinger().toSecondsIntBound());
        }
        if (this.socketConfig.getTcpKeepIdle() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPIDLE", this.socketConfig.getTcpKeepIdle());
        }
        if (this.socketConfig.getTcpKeepInterval() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPINTERVAL", this.socketConfig.getTcpKeepInterval());
        }
        if (this.socketConfig.getTcpKeepCount() > 0) {
            SocketSupport.setOption(this.serverSocket, "TCP_KEEPCOUNT", this.socketConfig.getTcpKeepCount());
        }
        if (!(socket instanceof SSLSocket) && this.sslSocketFactory != null) {
            Object object;
            SSLSocket sSLSocket = (SSLSocket)this.sslSocketFactory.createSocket(socket, null, -1, false);
            sSLSocket.setUseClientMode(false);
            if (this.sslSetupHandler != null) {
                object = sSLSocket.getSSLParameters();
                this.sslSetupHandler.execute((SSLParameters)object);
                sSLSocket.setSSLParameters((SSLParameters)object);
            }
            try {
                sSLSocket.startHandshake();
                object = sSLSocket.getSession();
                if (object == null) {
                    throw new SSLHandshakeException("SSL session not available");
                }
                return this.connectionFactory.createConnection(sSLSocket, socket);
            }
            catch (IOException iOException) {
                Closer.closeQuietly(sSLSocket);
                throw iOException;
            }
        }
        return this.connectionFactory.createConnection(socket);
    }

    @Override
    public void run() {
        try {
            while (!this.isTerminated() && !Thread.interrupted()) {
                Socket socket = this.serverSocket.accept();
                try {
                    Object object = this.createConnection(socket);
                    object = new Worker(this.httpService, (HttpServerConnection)object, this.exceptionListener);
                    this.executorService.execute((Runnable)object);
                }
                catch (IOException | RuntimeException exception) {
                    Closer.closeQuietly(socket);
                    this.exceptionListener.onError(exception);
                }
            }
            return;
        }
        catch (Exception exception) {
            this.exceptionListener.onError(exception);
            return;
        }
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public void terminate() throws IOException {
        if (this.terminated.compareAndSet(false, true)) {
            this.serverSocket.close();
        }
    }
}

