/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.bootstrap;

import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.impl.io.HttpService;
import org.apache.hc.core5.http.io.HttpServerConnection;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.CloseMode;

class Worker
implements Runnable {
    private final HttpService httpservice;
    private final HttpServerConnection conn;
    private final ExceptionListener exceptionListener;

    Worker(HttpService httpService, HttpServerConnection httpServerConnection, ExceptionListener exceptionListener) {
        this.httpservice = httpService;
        this.conn = httpServerConnection;
        this.exceptionListener = exceptionListener;
    }

    public HttpServerConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && this.conn.isOpen()) {
                HttpCoreContext httpCoreContext = HttpCoreContext.create();
                this.httpservice.handleRequest(this.conn, httpCoreContext);
            }
            this.conn.close();
            return;
        }
        catch (Exception exception) {
            this.exceptionListener.onError(this.conn, exception);
            return;
        }
        finally {
            this.conn.close(CloseMode.IMMEDIATE);
        }
    }
}

